/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.Radio;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.MimeType;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.text.StringSubstitutor;

class MetaDataFileNameGenerator {
    private final String fileNameFormat;
    private final Path targetDirectory;
    private final int consumerId;
    private final boolean requireMetaData;

    MetaDataFileNameGenerator(@NonNull String fileNameFormat, @NonNull ConsumerContext consumerContext, boolean requireMetaData) {
        if (fileNameFormat == null) {
            throw new NullPointerException("fileNameFormat is marked non-null but is null");
        }
        if (consumerContext == null) {
            throw new NullPointerException("consumerContext is marked non-null but is null");
        }
        this.fileNameFormat = fileNameFormat;
        this.targetDirectory = consumerContext.getTargetDirectory();
        this.consumerId = consumerContext.getId();
        this.requireMetaData = requireMetaData;
    }

    static String sanitizeFileName(String in) {
        String sanitized = in;
        sanitized = sanitized.replaceAll("^[ ?:-]+", "_");
        if ((sanitized = sanitized.replaceAll("[/:\\|?$\\\\()#]", "_")).length() > 192) {
            sanitized = sanitized.substring(0, 192);
        }
        return sanitized;
    }

    private static String getMetaDataField(MetaData metaData, Function<MetaData, Optional<String>> getter, String fallback) {
        Optional<String> value;
        String result = fallback;
        if (metaData != null && (value = getter.apply(metaData)) != null && value.isPresent()) {
            result = value.get().trim();
        }
        return MetaDataFileNameGenerator.sanitizeFileName(result);
    }

    private StringSubstitutor newStringSubstitutor(Radio radio, MetaData metaData, MimeType mimeTypeNullable) {
        String unknown = "unknown";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("id", Integer.toString(this.consumerId));
        values.put("title", MetaDataFileNameGenerator.getMetaDataField(metaData, MetaData::getTitle, unknown));
        values.put("artist", MetaDataFileNameGenerator.getMetaDataField(metaData, MetaData::getArtist, unknown));
        values.put("stationUrl", MetaDataFileNameGenerator.getMetaDataField(metaData, MetaData::getStationUrl, unknown));
        values.put("stationName", MetaDataFileNameGenerator.getMetaDataField(metaData, MetaData::getStationName, unknown));
        values.put("stationHost", MetaDataFileNameGenerator.getMetaDataField(metaData, m -> m.getStationUrl().map(url -> URI.create(url).getHost()), unknown));
        values.put("radioName", MetaDataFileNameGenerator.sanitizeFileName(radio.getName().trim()));
        values.put("radioHost", MetaDataFileNameGenerator.sanitizeFileName(radio.getUri().getHost()));
        values.put("radioUri", MetaDataFileNameGenerator.sanitizeFileName(radio.getUri().toASCIIString()));
        values.put("stationNameOrRadioName", MetaDataFileNameGenerator.getMetaDataField(metaData, MetaData::getStationName, MetaDataFileNameGenerator.sanitizeFileName(radio.getName())));
        values.put("index", MetaDataFileNameGenerator.getMetaDataField(metaData, m -> m.getIndex().map(intValue -> String.format("%03d", intValue)), unknown));
        values.put("suffix", MetaDataFileNameGenerator.suffixFromContentType(mimeTypeNullable));
        StringSubstitutor result = new StringSubstitutor(values);
        return result;
    }

    Optional<Path> getFileFrom(Radio radio, MetaData metaData, MimeType contentType) {
        Optional<Path> result = Optional.empty();
        if (!(metaData == null && this.requireMetaData || contentType == null)) {
            StringSubstitutor substitutor = this.newStringSubstitutor(radio, metaData, contentType);
            String targetName = substitutor.replace(this.fileNameFormat);
            Path path = this.targetDirectory.resolve(targetName);
            if (Files.exists(path, new LinkOption[0])) {
                path = MetaDataFileNameGenerator.generateNonExistingPath(path);
            }
            if (!path.startsWith(this.targetDirectory)) {
                throw new IllegalArgumentException("Generated file name " + String.valueOf(path) + " is outside target directory " + String.valueOf(this.targetDirectory));
            }
            result = Optional.of(path);
        }
        return result;
    }

    static Path generateNonExistingPath(Path currentPath) {
        Pattern withCountPattern = Pattern.compile("(.*)-([0-9]+)(\\.[^.]+)");
        Pattern withoutCountPattern = Pattern.compile("(.*)(\\.[^.]+)");
        while (Files.exists(currentPath, new LinkOption[0])) {
            String prefix;
            Path parent = currentPath.getParent();
            String fileName = currentPath.getFileName().toString();
            Matcher matcher = withCountPattern.matcher(fileName);
            if (matcher.matches()) {
                prefix = matcher.group(1);
                String count = matcher.group(2);
                String suffix = matcher.group(3);
                int countInt = Integer.parseInt(count);
                String newName = String.format("%s-%d%s", prefix, countInt + 1, suffix);
                currentPath = parent.resolve(newName);
                continue;
            }
            matcher = withoutCountPattern.matcher(fileName);
            if (!matcher.matches()) continue;
            prefix = matcher.group(1);
            String suffix = matcher.group(2);
            String newName = String.format("%s-%d%s", prefix, 1, suffix);
            currentPath = parent.resolve(newName);
        }
        return currentPath;
    }

    private static String suffixFromContentType(MimeType contentType) {
        if (contentType == null) {
            return "";
        }
        return contentType.getSuffix();
    }
}

