/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.aachelper;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACClassLoaderHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AACClassLoaderHelper.class);
    private static final String URL_AAC = "https://repo1.maven.org/maven2/com/tianscar/javasound/javasound-aac/0.9.8/javasound-aac-0.9.8.jar";
    private static final String URL_RES = "https://repo1.maven.org/maven2/com/tianscar/javasound/javasound-resloader/0.1.3/javasound-resloader-0.1.3.jar";
    private static final String JAR_AAC = "javasound-aac-0.9.8.jar";
    private static final String JAR_RES = "javasound-resloader-0.1.3.jar";

    static Optional<Path> findLibsDirectory() {
        try {
            URI uri = AACClassLoaderHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path path = Paths.get(uri);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                log.debug("Path {} is regular file, we are in a jar", (Object)path);
                return Optional.of(path.getParent());
            }
        }
        catch (URISyntaxException e) {
            log.debug("Exception, but it is ok {}", (Object)e.getMessage());
            return Optional.empty();
        }
        return Optional.empty();
    }

    static ClassLoader loadPluginClassLoaderRemoteUrl() throws MalformedURLException {
        List<URL> urls = Arrays.asList(URI.create(URL_AAC).toURL(), URI.create(URL_RES).toURL());
        URL[] urlArray = urls.toArray(new URL[0]);
        return new URLClassLoader(urlArray, AACClassLoaderHelper.class.getClassLoader());
    }

    static Optional<ClassLoader> loadPluginClassLoaderPluginDir() throws MalformedURLException {
        Optional<Path> libDirPath = AACClassLoaderHelper.findLibsDirectory();
        if (libDirPath.isPresent()) {
            Path libDir = libDirPath.get();
            Path providedDir = libDir.resolve("provided");
            if (Files.isDirectory(providedDir, new LinkOption[0])) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String jar : Arrays.asList(JAR_AAC, JAR_RES)) {
                    Path jarPath = providedDir.resolve(jar);
                    if (!Files.isRegularFile(jarPath, new LinkOption[0])) {
                        log.debug("Could not find jar {} in path {}", (Object)jar, (Object)providedDir);
                        return Optional.empty();
                    }
                    urls.add(jarPath.toUri().toURL());
                }
                log.debug("Found JARs: {}", urls);
                URL[] urlArray = urls.toArray(new URL[0]);
                return Optional.of(new URLClassLoader(urlArray, AACClassLoaderHelper.class.getClassLoader()));
            }
            log.debug("Provided does not exist");
        } else {
            log.debug("Lib dir path does not exist");
        }
        return Optional.empty();
    }

    public static ClassLoader loadPluginClassLoader() throws MalformedURLException {
        ClassLoader result;
        Optional<ClassLoader> pluginDirClassLoader = AACClassLoaderHelper.loadPluginClassLoaderPluginDir();
        if (pluginDirClassLoader.isPresent()) {
            result = pluginDirClassLoader.get();
        } else {
            log.warn("Using remote JARs, should only be used for development!");
            result = AACClassLoaderHelper.loadPluginClassLoaderRemoteUrl();
        }
        return result;
    }
}

