/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.IOException;
import net.sourceforge.jaad.SampleBuffer;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.spi.javasound.AACAudioInputStream;
import net.sourceforge.jaad.spi.javasound.AsynchronousAudioInputStream;
import net.sourceforge.jaad.spi.javasound.Utils;

class DecodedAACAudioInputStream
extends AsynchronousAudioInputStream {
    final ADTSDemultiplexer adts;
    final Decoder decoder;
    final SampleBuffer sampleBuffer;

    DecodedAACAudioInputStream(AACAudioInputStream stream) throws IOException {
        super(stream.in, Utils.getPCMFormat(stream.getFormat()), stream.getFrameLength());
        this.adts = stream.adts;
        this.decoder = stream.decoder;
        this.sampleBuffer = stream.sampleBuffer;
    }

    @Override
    public void execute() {
        try {
            this.decoder.decodeFrame(this.adts.readNextFrame(), this.sampleBuffer);
            this.buffer.write(this.sampleBuffer.getData());
        }
        catch (IOException e) {
            this.buffer.close();
        }
    }
}

