/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.javasound.sampled;

import com.tianscar.javasound.sampled.spi.AudioResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioResourceLoader {
    public static AudioFileFormat getAudioFileFormat(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        List<AudioResourceReader> providers = AudioResourceLoader.getAudioResourceReaders();
        AudioFileFormat format = null;
        for (AudioResourceReader reader : providers) {
            try {
                format = reader.getAudioFileFormat(resourceLoader, name);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return format;
    }

    public static AudioInputStream getAudioInputStream(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        List<AudioResourceReader> providers = AudioResourceLoader.getAudioResourceReaders();
        AudioInputStream audioStream = null;
        for (AudioResourceReader reader : providers) {
            try {
                audioStream = reader.getAudioInputStream(resourceLoader, name);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
        }
        if (audioStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input resource");
        }
        return audioStream;
    }

    private static List<AudioResourceReader> getAudioResourceReaders() {
        return AudioResourceLoader.getProviders(AudioResourceReader.class);
    }

    private static <T> List<T> getProviders(Class<T> providerClass) {
        ArrayList<T> providers = new ArrayList<T>();
        for (T t : ServiceLoader.load(providerClass)) {
            if (!providerClass.isInstance(t)) continue;
            providers.add(t);
        }
        return providers;
    }
}

