/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.javasound.midi;

import com.tianscar.javasound.midi.spi.MidiResourceReader;
import com.tianscar.javasound.midi.spi.SoundbankResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.Soundbank;

public class MidiResourceLoader {
    private MidiResourceLoader() {
        throw new UnsupportedOperationException();
    }

    public static MidiFileFormat getMidiFileFormat(ClassLoader resourceLoader, String name) throws InvalidMidiDataException, IOException {
        List<MidiResourceReader> providers = MidiResourceLoader.getMidiResourceReaders();
        MidiFileFormat format = null;
        for (MidiResourceReader reader : providers) {
            try {
                format = reader.getMidiFileFormat(resourceLoader, name);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("resource is not a supported file type");
        }
        return format;
    }

    public static Sequence getSequence(ClassLoader resourceLoader, String name) throws InvalidMidiDataException, IOException {
        List<MidiResourceReader> providers = MidiResourceLoader.getMidiResourceReaders();
        Sequence sequence = null;
        for (MidiResourceReader reader : providers) {
            try {
                sequence = reader.getSequence(resourceLoader, name);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from resource");
        }
        return sequence;
    }

    public static Soundbank getSoundbank(ClassLoader resourceLoader, String name) throws InvalidMidiDataException, IOException {
        List<SoundbankResourceReader> providers = MidiResourceLoader.getSoundbankResourceReaders();
        for (SoundbankResourceReader provider : providers) {
            SoundbankResourceReader sp = provider;
            Soundbank s = sp.getSoundbank(resourceLoader, name);
            if (s == null) continue;
            return s;
        }
        throw new InvalidMidiDataException("cannot get soundbank from resource");
    }

    private static List<SoundbankResourceReader> getSoundbankResourceReaders() {
        return MidiResourceLoader.getProviders(SoundbankResourceReader.class);
    }

    private static List<MidiResourceReader> getMidiResourceReaders() {
        return MidiResourceLoader.getProviders(MidiResourceReader.class);
    }

    private static <T> List<T> getProviders(Class<T> providerClass) {
        ArrayList<T> providers = new ArrayList<T>();
        for (T t : ServiceLoader.load(providerClass)) {
            if (!providerClass.isInstance(t)) continue;
            providers.add(t);
        }
        return providers;
    }
}

