/*
 * Decompiled with CFR 0.152.
 */
package com.github.trilarion.sound.sampled;

import com.github.trilarion.sound.sampled.CircularBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class AsynchronousFilteredAudioInputStream
extends AudioInputStream
implements CircularBuffer.BufferListener {
    private static final Logger LOG = Logger.getLogger(AsynchronousFilteredAudioInputStream.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 327670;
    private static final int DEFAULT_MIN_AVAILABLE = 4096;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CircularBuffer m_circularBuffer;
    private byte[] m_abSingleByte;

    public AsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength) {
        this(outputFormat, lLength, 327670, 4096);
    }

    public AsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength, int nBufferSize, int nMinAvailable) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), outputFormat, lLength);
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.<init>(): begin");
        this.m_circularBuffer = new CircularBuffer(nBufferSize, false, true, this);
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.<init>(): end");
    }

    protected CircularBuffer getCircularBuffer() {
        return this.m_circularBuffer;
    }

    @Override
    public int read() throws IOException {
        int nReturn;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        int nByte = (nReturn = this.read(this.m_abSingleByte)) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return nByte;
    }

    @Override
    public int read(byte[] abData) throws IOException {
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.read(byte[]): begin");
        int nRead = this.read(abData, 0, abData.length);
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.read(byte[]): end");
        return nRead;
    }

    @Override
    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.read(byte[], int, int): begin");
        int nRead = this.m_circularBuffer.read(abData, nOffset, nLength);
        LOG.log(Level.FINE, "TAsynchronousFilteredAudioInputStream.read(byte[], int, int): end");
        return nRead;
    }

    @Override
    public long skip(long lSkip) throws IOException {
        for (long lSkipped = 0L; lSkipped < lSkip; ++lSkipped) {
            int nReturn = this.read();
            if (nReturn != -1) continue;
            return lSkipped;
        }
        return lSkip;
    }

    @Override
    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    @Override
    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int nReadLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }
}

