/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;

class OffsetFilterStream
extends FilterInputStream {
    private long offset;
    private long marked;

    OffsetFilterStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            ++this.offset;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.offset += (long)result;
        }
        return result;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.marked = this.offset;
        super.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.offset = this.marked;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.offset += result;
        return result;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Generated
    public long getMarked() {
        return this.marked;
    }

    @Generated
    public void setMarked(long marked) {
        this.marked = marked;
    }
}

