/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.ApacheHttpClient5ConnectionBuilder;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.JavaNetHttpConnectionBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionBuilderFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConnectionBuilderFactory.class);
    private final HttpClientType httpClientType;

    public HttpConnectionBuilderFactory(@NonNull HttpClientType httpClientType) {
        if (httpClientType == null) {
            throw new NullPointerException("httpClientType is marked non-null but is null");
        }
        log.debug("Using client {}", (Object)httpClientType);
        this.httpClientType = httpClientType;
    }

    public HttpConnectionBuilder newInstance(URI url) {
        return this.httpClientType.builder(url);
    }

    public static enum HttpClientType {
        JAVA_NET(JavaNetHttpConnectionBuilder::new),
        APACHE_CLIENT_5(url -> {
            try {
                return new ApacheHttpClient5ConnectionBuilder((URI)url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });

        private final Function<URI, HttpConnectionBuilder> builder;

        private HttpClientType(Function<URI, HttpConnectionBuilder> inBuilder) {
            if (inBuilder == null) {
                throw new NullPointerException("inBuilder is marked non-null but is null");
            }
            this.builder = inBuilder;
        }

        HttpConnectionBuilder builder(@NonNull URI url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            return this.builder.apply(url);
        }
    }
}

