/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.ConsoleMetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.MetaDataConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.MimeType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import lombok.Generated;
import net.sourceforge.jaad.spi.javasound.AACAudioFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPlayConsumer
extends MetaDataConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamPlayConsumer.class);

    public StreamPlayConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
    }

    private AudioInputStream getAudioInputStream(String contentType, InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioInputStream result;
        if (contentType == null) {
            log.error("Content type is null");
            throw new UnsupportedAudioFileException("No mapping for NULL content type");
        }
        Optional<MimeType> mimeType = MimeType.byContentType(contentType);
        if (!mimeType.isPresent()) {
            log.error("Derived mime type is null");
            throw new UnsupportedAudioFileException("No mapping for NULL mime type");
        }
        switch (mimeType.get()) {
            case AUDIO_AAC: {
                log.debug("Using hard-wired AAC plugin for content-type {}", (Object)contentType);
                result = new AACAudioFileReader().getAudioInputStream(inputStream);
                break;
            }
            default: {
                log.debug("Using auto-detected plugin for content-type {}", (Object)contentType);
                result = AudioSystem.getAudioInputStream(inputStream);
            }
        }
        return result;
    }

    @Override
    protected void __accept(HttpConnection t, InputStream inputStream) {
        try {
            this.getStreamMetaData().setMetaDataConsumer(new ConsoleMetaDataConsumer());
            byte[] buffer = new byte[8192];
            String contentType = t.getContentType();
            log.debug("Content type {}", (Object)contentType);
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            AudioInputStream input = this.getAudioInputStream(contentType, inputStream);
            log.debug("Input format {}", (Object)input.getFormat());
            boolean bigEndian = input.getFormat().isBigEndian();
            AudioFormat targetFormat = new AudioFormat(44100.0f, 16, 2, true, bigEndian);
            log.debug("Target format {}", (Object)targetFormat);
            AudioInputStream converted = AudioSystem.getAudioInputStream(targetFormat, input);
            Mixer.Info mixerInfo = this.getContext().getMixerInfo();
            try (SourceDataLine line = AudioSystem.getSourceDataLine(targetFormat, mixerInfo);){
                long bufferSize = line.getBufferSize();
                log.debug("Streaming from url {} to line {}, format {}, buffer size {}", new Object[]{this.getContext().getUri().toASCIIString(), line.getLineInfo().toString(), contentType, bufferSize});
                long ofs = 0L;
                line.open(targetFormat);
                try {
                    int len;
                    while (-1 != (len = converted.read(buffer))) {
                        log.trace("Read {} bytes", (Object)len);
                        ofs += (long)len;
                        if (!line.isRunning() && line.available() < len) {
                            log.debug("Starting line, not yet running, {} / {} available", (Object)line.available(), (Object)bufferSize);
                            line.start();
                        }
                        line.write(buffer, 0, len);
                        log.trace("Wrote {} bytes (total {})", (Object)len, (Object)ofs);
                    }
                }
                catch (IOException ioe) {
                    throw new RadioException(true, (Throwable)ioe);
                }
                finally {
                    line.stop();
                }
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            log.warn("URL " + this.getContext().getUri().toASCIIString() + " broke down", (Throwable)ex);
            throw new RadioException(false, (Throwable)ex);
        }
    }
}

