/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.AbstractConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M3UConsumer
extends AbstractConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(M3UConsumer.class);

    public M3UConsumer(ConsumerContext context) {
        super(context);
    }

    @Override
    protected void _accept(HttpConnection t) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(t.getInputStream()));){
            List lines = bufferedReader.lines().filter(l -> l.startsWith("http")).collect(Collectors.toList());
            log.debug("Found {} lines with URLs", (Object)lines.size());
            for (String line : lines) {
                log.debug("Found line {}", (Object)line);
                this.getConnectionHandler().consume(URI.create(line));
            }
        }
        catch (IOException ex) {
            log.warn("URL " + this.getContext().getUri().toASCIIString() + " broke down", (Throwable)ex);
            throw new RadioException(true, (Throwable)ex);
        }
    }
}

