/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import net.sourceforge.jaad.SampleBuffer;
import net.sourceforge.jaad.aac.DecoderConfig;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.mp4.api.MetaData;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.spi.javasound.AACAudioFormat;

public class AACAudioFileFormat
extends AudioFileFormat {
    public AACAudioFileFormat(Movie movie, DecoderConfig config, SampleBuffer sampleBuffer) {
        super(Type.MP4_AAC, new AACAudioFormat(config, sampleBuffer), -1, AACAudioFileFormat.generateProperties(movie));
    }

    public AACAudioFileFormat(ADTSDemultiplexer adts, DecoderConfig config, SampleBuffer sampleBuffer) {
        super(Type.AAC, new AACAudioFormat(config, sampleBuffer), -1, AACAudioFileFormat.generateProperties(adts, config));
    }

    private static Map<String, Object> generateProperties(Movie movie) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", (long)(movie.getDuration() * 1000000.0));
        properties.put("mp4.creationtime", movie.getCreationTime());
        properties.put("mp4.modificationtime", movie.getModificationTime());
        if (movie.containsMetaData()) {
            MetaData metaData = movie.getMetaData();
            for (Map.Entry<MetaData.Field<?>, Object> entry : metaData.getAll().entrySet()) {
                String entryName;
                switch (entryName = entry.getKey().getName().replaceAll(" ", "").toLowerCase(Locale.ROOT)) {
                    case "artist": {
                        entryName = "author";
                        break;
                    }
                    case "comments": {
                        entryName = "comment";
                        break;
                    }
                    case "releasedate": {
                        entryName = "date";
                        break;
                    }
                    default: {
                        entryName = "mp4." + entryName;
                    }
                }
                properties.put(entryName, entry.getValue());
            }
        }
        return properties;
    }

    private static Map<String, Object> generateProperties(ADTSDemultiplexer adts, DecoderConfig config) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int frames = 1;
        try {
            while (true) {
                adts.readNextFrame();
                ++frames;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            return properties;
        }
        double lengthInSeconds = (double)frames * (double)config.getSampleLength() / (double)config.getSampleFrequency().getFrequency();
        properties.put("duration", (long)(lengthInSeconds * 1000000.0));
        return properties;
    }

    public static class Type
    extends AudioFileFormat.Type {
        public static final AudioFileFormat.Type AAC = new Type("AAC", "aac");
        public static final AudioFileFormat.Type MP4_AAC = new Type("MPEG-4 AAC", "m4a");

        private Type(String name, String extension) {
            super(name, extension);
        }
    }
}

