/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.javasound.sampled;

import com.tianscar.javasound.sampled.spi.AudioResourceReader;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JDKAudioResourceReader
implements AudioResourceReader {
    @Override
    public AudioFileFormat getAudioFileFormat(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        try (InputStream stream = resourceLoader.getResourceAsStream(name);){
            if (stream == null) {
                throw new IOException("could not load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
            }
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(stream);
            return audioFileFormat;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        InputStream stream = resourceLoader.getResourceAsStream(name);
        if (stream == null) {
            throw new IOException("could not load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
        }
        return AudioSystem.getAudioInputStream(stream);
    }
}

