/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.sourceforge.jaad.spi.javasound.CircularBuffer;

abstract class AsynchronousAudioInputStream
extends AudioInputStream
implements CircularBuffer.Trigger {
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private byte[] singleByte;
    protected final CircularBuffer buffer = new CircularBuffer(this);

    AsynchronousAudioInputStream(InputStream in, AudioFormat format, long length) throws IOException {
        super(in, format, length);
    }

    @Override
    public int read() throws IOException {
        if (this.singleByte == null) {
            this.singleByte = new byte[1];
        }
        int i = this.buffer.read(this.singleByte, 0, 1) == -1 ? -1 : this.singleByte[0] & 0xFF;
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.buffer.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.buffer.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        long temp;
        if (n % (long)this.frameSize != 0L) {
            n -= n % (long)this.frameSize;
        }
        if (this.frameLength != -1L && n / (long)this.frameSize > this.frameLength - this.framePos) {
            n = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((temp = this.mSkip(n)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (temp >= 0L) {
            this.framePos += temp / (long)this.frameSize;
        }
        return temp;
    }

    private long mSkip(long n) throws IOException {
        int nr;
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.availableRead();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }
}

