/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import com.tianscar.javasound.sampled.spi.AudioResourceReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import net.sourceforge.jaad.SampleBuffer;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.MP4Exception;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;
import net.sourceforge.jaad.spi.javasound.AACAudioFileFormat;
import net.sourceforge.jaad.spi.javasound.AACAudioInputStream;
import net.sourceforge.jaad.spi.javasound.MP4AudioInputStream;
import net.sourceforge.jaad.util.Utils;

public class AACAudioFileReader
extends AudioFileReader
implements AudioResourceReader {
    private static AACAudioInputStream decodeAACAudioInputStream(InputStream in) throws IOException {
        return (AACAudioInputStream)AACAudioFileReader.decodeAACAudio(in, false);
    }

    private static AudioFileFormat decodeAACAudioFileFormat(InputStream in) throws IOException {
        return (AudioFileFormat)AACAudioFileReader.decodeAACAudio(in, true);
    }

    private static Object decodeAACAudio(InputStream in, boolean fileFormat) throws IOException {
        ADTSDemultiplexer adts = new ADTSDemultiplexer(in);
        Decoder decoder = Decoder.create(adts.getDecoderInfo());
        SampleBuffer sampleBuffer = new SampleBuffer(decoder.getAudioFormat());
        if (fileFormat) {
            return new AACAudioFileFormat(adts, decoder.getConfig(), sampleBuffer);
        }
        return new AACAudioInputStream(adts, decoder, sampleBuffer, in, -1L);
    }

    private static MP4AudioInputStream decodeMP4AudioInputStream(MP4InputStream in) throws IOException, UnsupportedAudioFileException {
        return (MP4AudioInputStream)AACAudioFileReader.decodeMP4Audio(in, false);
    }

    private static AudioFileFormat decodeMP4AudioFileFormat(MP4InputStream in) throws IOException, UnsupportedAudioFileException {
        return (AudioFileFormat)AACAudioFileReader.decodeMP4Audio(in, true);
    }

    private static Object decodeMP4Audio(MP4InputStream in, boolean fileFormat) throws IOException, UnsupportedAudioFileException {
        MP4Container mp4;
        try {
            mp4 = new MP4Container(in);
        }
        catch (MP4Exception e) {
            throw new UnsupportedAudioFileException(e.getMessage());
        }
        Movie movie = mp4.getMovie();
        List<Track> tracks = movie.getTracks(AudioTrack.AudioCodec.AAC);
        if (tracks.isEmpty()) {
            throw new IOException("movie does not contain any AAC track");
        }
        AudioTrack track = (AudioTrack)tracks.get(0);
        Decoder decoder = Decoder.create(track.getDecoderSpecificInfo().getData());
        if (!track.hasMoreFrames()) {
            throw new IOException("no valid frame exists");
        }
        Frame frame = track.readNextFrame();
        if (frame == null) {
            throw new IOException("no valid frame exists");
        }
        SampleBuffer sampleBuffer = new SampleBuffer();
        decoder.decodeFrame(frame.getData(), sampleBuffer);
        if (fileFormat) {
            return new AACAudioFileFormat(movie, decoder.getConfig(), sampleBuffer);
        }
        return new MP4AudioInputStream(track, decoder, sampleBuffer, in, -1L);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        if (in instanceof MP4InputStream && ((MP4InputStream)in).seekSupported()) {
            ((MP4InputStream)in).seek(0L);
            if (AACAudioFileReader.checkMagic(in) == AACAudioFileFormat.Type.MP4_AAC) {
                ((MP4InputStream)in).seek(0L);
                return AACAudioFileReader.decodeMP4AudioFileFormat((MP4InputStream)in);
            }
        }
        in.mark(1000);
        try {
            AudioFileFormat.Type type = AACAudioFileReader.checkMagic(in);
            if (type == null) {
                throw new UnsupportedAudioFileException();
            }
            if (type == AACAudioFileFormat.Type.MP4_AAC) {
                in.reset();
                return AACAudioFileReader.decodeMP4AudioFileFormat(MP4InputStream.open(in));
            }
            try {
                return AACAudioFileReader.decodeAACAudioFileFormat(in);
            }
            catch (IOException e) {
                throw new UnsupportedAudioFileException();
            }
        }
        catch (UnsupportedAudioFileException e) {
            in.reset();
            throw e;
        }
    }

    private static AudioFileFormat.Type checkMagic(InputStream in) throws IOException {
        byte[] head = new byte[12];
        Utils.readNBytes(in, head);
        if (head[4] == 102 && head[5] == 116 && head[6] == 121 && head[7] == 112) {
            return AACAudioFileFormat.Type.MP4_AAC;
        }
        if (head[0] == 82 && head[1] == 73 && head[2] == 70 && head[3] == 70 && head[8] == 87 && head[9] == 65 && head[10] == 86 && head[11] == 69) {
            return null;
        }
        if (head[0] == 46 && head[1] == 115 && head[2] == 110 && head[3] == 100) {
            return null;
        }
        if (head[0] == 70 && head[1] == 79 && head[2] == 82 && head[3] == 77 && head[8] == 65 && head[9] == 73 && head[10] == 70 && head[11] == 70) {
            return null;
        }
        if (head[0] == 77 | head[0] == 109 && head[1] == 65 | head[1] == 97 && head[2] == 67 | head[2] == 99) {
            return null;
        }
        if (head[0] == 70 | head[0] == 102 && head[1] == 76 | head[1] == 108 && head[2] == 65 | head[2] == 97 && head[3] == 67 | head[3] == 99) {
            return null;
        }
        if (head[0] == 119 && head[1] == 118 && head[2] == 112 && head[3] == 107) {
            return null;
        }
        if (head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            return null;
        }
        if (head[0] == 79 | head[0] == 111 && head[1] == 71 | head[1] == 103 && head[2] == 71 | head[2] == 103) {
            return null;
        }
        return AACAudioFileFormat.Type.AAC;
    }

    private AudioFileFormat getAudioFileFormatAndClose(InputStream in) throws UnsupportedAudioFileException, IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(in);
            return audioFileFormat;
        }
        finally {
            in.close();
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormatAndClose(url.openStream());
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormatAndClose(Files.newInputStream(file.toPath(), StandardOpenOption.READ));
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream in) throws UnsupportedAudioFileException, IOException, IllegalArgumentException {
        if (!(in instanceof MP4InputStream) && !in.markSupported()) {
            throw new IllegalArgumentException("in.markSupported() == false");
        }
        if (in instanceof MP4InputStream) {
            ((MP4InputStream)in).seek(0L);
            return AACAudioFileReader.decodeMP4AudioInputStream((MP4InputStream)in);
        }
        in.mark(1000);
        AudioFileFormat.Type type = AACAudioFileReader.checkMagic(in);
        if (type == null) {
            throw new UnsupportedAudioFileException();
        }
        if (type == AACAudioFileFormat.Type.MP4_AAC) {
            in.reset();
            return AACAudioFileReader.decodeMP4AudioInputStream(MP4InputStream.open(in));
        }
        try {
            return AACAudioFileReader.decodeAACAudioInputStream(in);
        }
        catch (IOException e) {
            try {
                throw new UnsupportedAudioFileException();
            }
            catch (UnsupportedAudioFileException e2) {
                try {
                    in.reset();
                    throw e2;
                }
                catch (IOException e3) {
                    if ("movie does not contain any AAC track".equals(e3.getMessage())) {
                        throw new UnsupportedAudioFileException("movie does not contain any AAC track");
                    }
                    throw e3;
                }
            }
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream in = url.openStream();
        try {
            return this.getAudioInputStream(in.markSupported() ? in : new BufferedInputStream(in));
        }
        catch (IOException | UnsupportedAudioFileException e) {
            in.close();
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        InputStream in;
        block7: {
            in = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
            AudioFileFormat.Type type = AACAudioFileReader.checkMagic(in);
            if (type == null) {
                throw new UnsupportedAudioFileException();
            }
            if (type != AACAudioFileFormat.Type.MP4_AAC) break block7;
            in.close();
            return AACAudioFileReader.decodeMP4AudioInputStream(MP4InputStream.open(new RandomAccessFile(file, "r")));
            {
                catch (IOException e) {
                    if ("movie does not contain any AAC track".equals(e.getMessage())) {
                        throw new UnsupportedAudioFileException("movie does not contain any AAC track");
                    }
                    throw e;
                }
            }
        }
        try {
            return AACAudioFileReader.decodeAACAudioInputStream(in);
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
    }

    public AudioFileFormat getAudioFileFormat(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        InputStream in = resourceLoader.getResourceAsStream(name);
        if (in == null) {
            throw new IOException("Cannot load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
        }
        return this.getAudioFileFormatAndClose(in);
    }

    /*
     * Loose catch block
     */
    public AudioInputStream getAudioInputStream(ClassLoader resourceLoader, String name) throws UnsupportedAudioFileException, IOException {
        InputStream in;
        block8: {
            in = resourceLoader.getResourceAsStream(name);
            if (in == null) {
                throw new IOException("Cannot load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
            }
            AudioFileFormat.Type type = AACAudioFileReader.checkMagic(in);
            if (type == null) {
                throw new UnsupportedAudioFileException();
            }
            if (type != AACAudioFileFormat.Type.MP4_AAC) break block8;
            in.close();
            return AACAudioFileReader.decodeMP4AudioInputStream(MP4InputStream.open(resourceLoader, name));
            {
                catch (IOException e) {
                    if ("movie does not contain any AAC track".equals(e.getMessage())) {
                        throw new UnsupportedAudioFileException("movie does not contain any AAC track");
                    }
                    throw e;
                }
            }
        }
        try {
            return AACAudioFileReader.decodeAACAudioInputStream(in);
        }
        catch (IOException e) {
            throw new UnsupportedAudioFileException();
        }
    }
}

