/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.javasound.midi;

import com.tianscar.javasound.midi.spi.MidiResourceReader;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;

public class JDKMidiResourceReader
implements MidiResourceReader {
    @Override
    public MidiFileFormat getMidiFileFormat(ClassLoader resourceLoader, String name) throws InvalidMidiDataException, IOException {
        try (InputStream stream = resourceLoader.getResourceAsStream(name);){
            if (stream == null) {
                throw new IOException("could not load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
            }
            MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(stream);
            return midiFileFormat;
        }
    }

    @Override
    public Sequence getSequence(ClassLoader resourceLoader, String name) throws InvalidMidiDataException, IOException {
        InputStream stream = resourceLoader.getResourceAsStream(name);
        if (stream == null) {
            throw new IOException("could not load resource \"" + name + "\" with ClassLoader \"" + resourceLoader + "\"");
        }
        return MidiSystem.getSequence(stream);
    }
}

