/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import lombok.Generated;

public class ConnectionParams {
    private final String apiUrl;
    private final int timeout;
    private final String userAgent;
    private final String proxyUri;
    private final String proxyUser;
    private final String proxyPassword;
    private final long retryInterval;
    private final int retries;

    void check() {
        if (this.apiUrl == null) {
            throw new IllegalArgumentException("apiUrl must not be null");
        }
        if (this.timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0, but is " + this.getTimeout());
        }
        if (this.retries <= 0) {
            throw new IllegalArgumentException("retries must be > 0, but is " + this.getRetries());
        }
        if (this.retryInterval <= 0L) {
            throw new IllegalArgumentException("retryInterval must be > 0, but is " + this.getRetryInterval());
        }
        if (this.userAgent == null) {
            throw new IllegalArgumentException("userAgent must not be null");
        }
        if (this.proxyUri != null) {
            if (this.proxyUser != null && this.proxyPassword == null) {
                throw new IllegalArgumentException("proxyUser was given, but not a proxyPassword");
            }
            if (this.proxyUser == null && this.proxyPassword != null) {
                throw new IllegalArgumentException("proxyUser was not given, but a proxyPassword");
            }
        }
    }

    @Generated
    private static long $default$retryInterval() {
        return 1000L;
    }

    @Generated
    private static int $default$retries() {
        return 3;
    }

    @Generated
    ConnectionParams(String apiUrl, int timeout, String userAgent, String proxyUri, String proxyUser, String proxyPassword, long retryInterval, int retries) {
        this.apiUrl = apiUrl;
        this.timeout = timeout;
        this.userAgent = userAgent;
        this.proxyUri = proxyUri;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.retryInterval = retryInterval;
        this.retries = retries;
    }

    @Generated
    public static ConnectionParamsBuilder builder() {
        return new ConnectionParamsBuilder();
    }

    @Generated
    String getApiUrl() {
        return this.apiUrl;
    }

    @Generated
    int getTimeout() {
        return this.timeout;
    }

    @Generated
    String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    String getProxyUri() {
        return this.proxyUri;
    }

    @Generated
    String getProxyUser() {
        return this.proxyUser;
    }

    @Generated
    String getProxyPassword() {
        return this.proxyPassword;
    }

    @Generated
    long getRetryInterval() {
        return this.retryInterval;
    }

    @Generated
    int getRetries() {
        return this.retries;
    }

    @Generated
    public static class ConnectionParamsBuilder {
        @Generated
        private String apiUrl;
        @Generated
        private int timeout;
        @Generated
        private String userAgent;
        @Generated
        private String proxyUri;
        @Generated
        private String proxyUser;
        @Generated
        private String proxyPassword;
        @Generated
        private boolean retryInterval$set;
        @Generated
        private long retryInterval$value;
        @Generated
        private boolean retries$set;
        @Generated
        private int retries$value;

        @Generated
        ConnectionParamsBuilder() {
        }

        @Generated
        public ConnectionParamsBuilder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder proxyUri(String proxyUri) {
            this.proxyUri = proxyUri;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder proxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder retryInterval(long retryInterval) {
            this.retryInterval$value = retryInterval;
            this.retryInterval$set = true;
            return this;
        }

        @Generated
        public ConnectionParamsBuilder retries(int retries) {
            this.retries$value = retries;
            this.retries$set = true;
            return this;
        }

        @Generated
        public ConnectionParams build() {
            long retryInterval$value = this.retryInterval$value;
            if (!this.retryInterval$set) {
                retryInterval$value = ConnectionParams.$default$retryInterval();
            }
            int retries$value = this.retries$value;
            if (!this.retries$set) {
                retries$value = ConnectionParams.$default$retries();
            }
            return new ConnectionParams(this.apiUrl, this.timeout, this.userAgent, this.proxyUri, this.proxyUser, this.proxyPassword, retryInterval$value, retries$value);
        }

        @Generated
        public String toString() {
            return "ConnectionParams.ConnectionParamsBuilder(apiUrl=" + this.apiUrl + ", timeout=" + this.timeout + ", userAgent=" + this.userAgent + ", proxyUri=" + this.proxyUri + ", proxyUser=" + this.proxyUser + ", proxyPassword=" + this.proxyPassword + ", retryInterval$value=" + this.retryInterval$value + ", retries$value=" + this.retries$value + ")";
        }
    }
}

