/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.AdvancedSearch;
import de.sfuhrm.radiobrowser4j.Limit;
import de.sfuhrm.radiobrowser4j.ListParameter;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.PagingSpliterator;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.RestDelegate;
import de.sfuhrm.radiobrowser4j.RestDelegateJaxRsImpl;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiobrowser4j.Stats;
import de.sfuhrm.radiobrowser4j.UrlResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioBrowser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadioBrowser.class);
    @Deprecated
    protected static final String DEFAULT_API_URL = "https://at1.api.radio-browser.info/";
    private final RestDelegate rest;
    private final String userAgent;

    public RadioBrowser(@NonNull String apiUrl, int timeout, @NonNull String myUserAgent) {
        this(apiUrl, timeout, myUserAgent, null, null, null);
        if (apiUrl == null) {
            throw new NullPointerException("apiUrl is marked non-null but is null");
        }
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
    }

    public RadioBrowser(@NonNull String apiUrl, int timeout, @NonNull String myUserAgent, String proxyUri, String proxyUser, String proxyPassword) {
        if (apiUrl == null) {
            throw new NullPointerException("apiUrl is marked non-null but is null");
        }
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0, but is " + timeout);
        }
        this.userAgent = myUserAgent;
        this.rest = new RestDelegateJaxRsImpl(URI.create(apiUrl), timeout, proxyUri, proxyUser, proxyPassword, myUserAgent);
    }

    @Deprecated
    public RadioBrowser(int timeout, String myUserAgent) {
        this(DEFAULT_API_URL, timeout, myUserAgent);
    }

    private static String paths(String ... components) {
        return Arrays.stream(components).collect(Collectors.joining("/"));
    }

    private Map<String, Integer> retrieveValueStationCountList(String subPath) {
        List<Map<String, String>> map = this.rest.postWithListOfMapOfString(subPath, Collections.emptyMap());
        return map.stream().collect(Collectors.toMap(m -> (String)m.get("name"), m -> Integer.parseInt((String)m.get("stationcount")), (a, b) -> a));
    }

    public Map<String, Integer> listCountries() {
        return this.retrieveValueStationCountList("json/countries");
    }

    public Map<String, Integer> listCodecs() {
        return this.retrieveValueStationCountList("json/codecs");
    }

    public Map<String, Integer> listLanguages() {
        return this.retrieveValueStationCountList("json/languages");
    }

    public Map<String, Integer> listTags() {
        return this.retrieveValueStationCountList("json/tags");
    }

    private List<Station> listStationsPathWithPaging(Optional<Paging> paging, String path, ListParameter ... listParam) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        paging.ifPresent(p -> p.apply(requestParams));
        Arrays.stream(listParam).forEach(lp -> lp.apply(requestParams));
        return this.rest.postWithListOfStation(path, requestParams);
    }

    private List<Station> listStationsPathWithLimit(Optional<Limit> limit, String path, ListParameter ... listParam) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Arrays.stream(listParam).forEach(lp -> lp.apply(requestParams));
        String myPath = path;
        if (limit.isPresent()) {
            myPath = myPath + '/' + limit.get().getSize();
        }
        return this.rest.postWithListOfStation(myPath, requestParams);
    }

    public List<Station> listStations(@NonNull Paging paging, ListParameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        return this.listStationsPathWithPaging(Optional.of(paging), "json/stations", listParam);
    }

    public Stream<Station> listStations(ListParameter ... listParam) {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStations((Paging)p, listParam)), false);
    }

    public List<Station> listBrokenStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/broken", new ListParameter[0]);
    }

    public Stream<Station> listBrokenStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/broken", new ListParameter[0])), false);
    }

    public List<Station> listImprovableStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return Collections.emptyList();
    }

    @Deprecated
    public Stream<Station> listImprovableStations() {
        return new ArrayList().stream();
    }

    public List<Station> listTopClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topclick", new ListParameter[0]);
    }

    public Stream<Station> listTopClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topclick", new ListParameter[0])), false);
    }

    public List<Station> listTopVoteStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topvote", new ListParameter[0]);
    }

    public Stream<Station> listTopVoteStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topvote", new ListParameter[0])), false);
    }

    public List<Station> listLastClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastclick", new ListParameter[0]);
    }

    public Stream<Station> listLastClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastclick", new ListParameter[0])), false);
    }

    public List<Station> listLastChangedStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastchange", new ListParameter[0]);
    }

    public Stream<Station> listLastChangedStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastchange", new ListParameter[0])), false);
    }

    public Optional<Station> getStationByUUID(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        List<Station> stationList = this.listStationsBy(Paging.at(0, 1), SearchMode.BYUUID, uuid.toString(), new ListParameter[0]);
        if (stationList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(stationList.get(0));
    }

    public List<Station> listStationsBy(@NonNull Paging paging, @NonNull SearchMode searchMode, @NonNull String searchTerm, ListParameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        paging.apply(requestParams);
        Arrays.stream(listParam).forEach(l -> l.apply(requestParams));
        String path = RadioBrowser.paths("json/stations", searchMode.name().toLowerCase(), searchTerm);
        return this.rest.postWithListOfStation(path, requestParams);
    }

    public Stream<Station> listStationsBy(@NonNull SearchMode searchMode, @NonNull String searchTerm, ListParameter ... listParam) {
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        Function fetcher = p -> {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            p.apply(requestParams);
            Arrays.stream(listParam).forEach(l -> l.apply(requestParams));
            String path = RadioBrowser.paths("json/stations", searchMode.name().toLowerCase(), searchTerm);
            return this.rest.postWithListOfStation(path, requestParams);
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher), false);
    }

    public URL resolveStreamUrl(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        String path = RadioBrowser.paths("json/url", stationUUID.toString());
        try {
            UrlResponse urlResponse = this.rest.get(path, UrlResponse.class);
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
            return new URL(urlResponse.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RadioBrowserException(e);
        }
    }

    public UUID postNewStation(@NonNull Station station) {
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        return this.postNewOrEditStation(station, "json/add");
    }

    public void voteForStation(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        String path = RadioBrowser.paths("json/vote", stationUUID.toString());
        UrlResponse urlResponse = this.rest.get(path, UrlResponse.class);
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
    }

    public Stats getServerStats() {
        return this.rest.get("json/stats", Stats.class);
    }

    public Stream<Station> listStationsWithAdvancedSearch(@NonNull AdvancedSearch advancedSearch) {
        if (advancedSearch == null) {
            throw new NullPointerException("advancedSearch is marked non-null but is null");
        }
        Function fetcher = p -> {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            p.apply(requestParams);
            advancedSearch.apply(requestParams);
            return this.rest.postWithListOfStation("/json/stations/search", requestParams);
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher), false);
    }

    private UUID postNewOrEditStation(@NonNull Station station, String path) {
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        station.apply(requestParams);
        UrlResponse urlResponse = this.rest.post(path, requestParams, UrlResponse.class);
        if (log.isDebugEnabled()) {
            log.debug("Result: {}", (Object)urlResponse);
        }
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
        return urlResponse.getUuid();
    }
}

