/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.ObjectMapperResolver;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.RestDelegate;
import de.sfuhrm.radiobrowser4j.Station;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestDelegateJaxRsImpl
implements RestDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestDelegateJaxRsImpl.class);
    private final Client client;
    private final URI endpoint;
    private final String userAgent;

    RestDelegateJaxRsImpl(URI inEndpoint, int inTimeout, String inProxyUri, String inProxyUser, String inProxyPassword, String inUserAgent) {
        this.endpoint = inEndpoint;
        this.client = RestDelegateJaxRsImpl.newClient(inTimeout, inProxyUri, inProxyUser, inProxyPassword);
        this.userAgent = inUserAgent;
    }

    private static Client newClient(int timeout, String proxyUri, String proxyUser, String proxyPassword) {
        Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(ObjectMapperResolver.class)).register(JacksonFeature.class)).register(GZipEncoder.class)).build();
        client.property("jersey.config.client.connectTimeout", (Object)timeout);
        client.property("jersey.config.client.readTimeout", (Object)timeout);
        if (proxyUri != null) {
            client.property("jersey.config.client.proxy.uri", (Object)proxyUri);
            if (proxyUser != null) {
                client.property("jersey.config.client.proxy.username", (Object)proxyUser);
            }
            if (proxyPassword != null) {
                client.property("jersey.config.client.proxy.password", (Object)proxyPassword);
            }
        }
        return client;
    }

    @Override
    public <T> T get(String path, Class<T> resultClass) {
        WebTarget webTarget = this.client.target(this.endpoint);
        return (T)webTarget.path(path).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).get(resultClass);
    }

    @Override
    public List<Station> postWithListOfStation(String path, Map<String, String> requestParams) {
        return this.post(path, requestParams, new GenericType<List<Station>>(){});
    }

    @Override
    public List<Map<String, String>> postWithListOfMapOfString(String path, Map<String, String> requestParams) {
        return this.post(path, requestParams, new GenericType<List<Map<String, String>>>(){});
    }

    @Override
    public <T> T post(String path, Map<String, String> requestParams, Class<T> resultClass) {
        Entity entity = Entity.form((MultivaluedMap)new MultivaluedHashMap(requestParams));
        WebTarget webTarget = this.client.target(this.endpoint);
        try (Response response = this.builder(webTarget.path(path)).post(entity);){
            RestDelegateJaxRsImpl.checkResponseStatus(response);
            Object object = response.readEntity(resultClass);
            return (T)object;
        }
    }

    private <T> T post(String path, Map<String, String> requestParams, GenericType<T> resultClass) {
        Entity entity = Entity.form((MultivaluedMap)new MultivaluedHashMap(requestParams));
        WebTarget webTarget = this.client.target(this.endpoint);
        try (Response response = this.builder(webTarget.path(path)).post(entity);){
            RestDelegateJaxRsImpl.checkResponseStatus(response);
            Object object = response.readEntity(resultClass);
            return (T)object;
        }
    }

    private Invocation.Builder builder(WebTarget in) {
        return in.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("Accept-Encoding", (Object)"gzip");
    }

    private static void checkResponseStatus(Response response) {
        RestDelegateJaxRsImpl.logResponseStatus(response);
        if (response.getStatus() != 200) {
            throw new RadioBrowserException(response.getStatusInfo().getReasonPhrase());
        }
    }

    private static void logResponseStatus(Response response) {
        if (response.getStatus() != 200) {
            log.warn("Non HTTP OK/200 status: status={}, reason={}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
        } else {
            log.debug("HTTP response status={}, reason={}, length={}", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase(), response.getLength()});
        }
    }
}

