/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.InetAddressHelper;
import de.sfuhrm.radiobrowser4j.RadioBrowser;
import de.sfuhrm.radiobrowser4j.Stats;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.glassfish.jersey.internal.util.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointDiscovery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointDiscovery.class);
    static final String DNS_API_ADDRESS = "all.api.radio-browser.info";
    private final String userAgent;
    private final String proxyUri;
    private final String proxyUser;
    private final String proxyPassword;
    private final InetAddressHelper inetAddressHelper;
    private Producer<ExecutorService> executorServiceProducer = () -> Executors.newFixedThreadPool(10);
    static final int DEFAULT_THREADS = 10;
    static final int DEFAULT_TIMEOUT_MILLIS = 5000;

    public EndpointDiscovery(@NonNull String myUserAgent) {
        this(myUserAgent, null, null, null);
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
    }

    public EndpointDiscovery(@NonNull String myUserAgent, String myProxyUri, String myProxyUser, String myProxyPassword) {
        this(myUserAgent, myProxyUri, myProxyUser, myProxyPassword, new InetAddressHelper());
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
    }

    EndpointDiscovery(@NonNull String myUserAgent, String myProxyUri, String myProxyUser, String myProxyPassword, InetAddressHelper myInetAddressHelper) {
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
        this.userAgent = myUserAgent;
        this.proxyUri = myProxyUri;
        this.proxyUser = myProxyUser;
        this.proxyPassword = myProxyPassword;
        this.inetAddressHelper = myInetAddressHelper;
    }

    List<String> apiUrls() throws UnknownHostException {
        InetAddress[] addresses = this.inetAddressHelper.getAllByName(DNS_API_ADDRESS);
        ArrayList<String> fqdns = new ArrayList<String>();
        for (InetAddress inetAddress : addresses) {
            fqdns.add(inetAddress.getCanonicalHostName());
        }
        return fqdns.stream().map(s -> String.format("https://%s/", s)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DiscoveryResult> discoverApiUrls(List<String> apiUrls) {
        ExecutorService executorService = (ExecutorService)this.executorServiceProducer.call();
        try {
            ArrayList<Future<DiscoveryResult>> futureList = new ArrayList<Future<DiscoveryResult>>();
            for (String apiUrl : apiUrls) {
                Callable<DiscoveryResult> callable = () -> {
                    long start = System.currentTimeMillis();
                    log.debug("Starting check for {}", (Object)apiUrl);
                    RadioBrowser radioBrowser = new RadioBrowser(apiUrl, 5000, this.userAgent, this.proxyUri, this.proxyUser, this.proxyPassword);
                    Stats stats = radioBrowser.getServerStats();
                    long duration = System.currentTimeMillis() - start;
                    log.debug("Finished check for {}, took {} ms", (Object)apiUrl, (Object)duration);
                    return new DiscoveryResult(apiUrl, duration, stats);
                };
                futureList.add(executorService.submit(callable));
            }
            ArrayList<DiscoveryResult> discoveryResults = new ArrayList<DiscoveryResult>();
            for (Future future : futureList) {
                try {
                    DiscoveryResult discoveryResult = (DiscoveryResult)future.get(5000L, TimeUnit.MILLISECONDS);
                    discoveryResults.add(discoveryResult);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    log.warn("Endpoint " + apiUrls.get(futureList.indexOf(future)) + " had an exception", (Throwable)e);
                }
            }
            ArrayList<DiscoveryResult> arrayList = discoveryResults;
            return arrayList;
        }
        finally {
            executorService.shutdown();
        }
    }

    public Optional<String> discover() throws IOException {
        List<DiscoveryResult> discoveryResults = this.discoverApiUrls(this.apiUrls());
        return discoveryResults.stream().sorted(Comparator.comparingLong(o -> ((DiscoveryResult)o).duration)).map(DiscoveryResult::getEndpoint).findFirst();
    }

    @Generated
    void setExecutorServiceProducer(Producer<ExecutorService> executorServiceProducer) {
        this.executorServiceProducer = executorServiceProducer;
    }

    static final class DiscoveryResult {
        private final String endpoint;
        private final long duration;
        private final Stats stats;

        @Generated
        public DiscoveryResult(String endpoint, long duration, Stats stats) {
            this.endpoint = endpoint;
            this.duration = duration;
            this.stats = stats;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public Stats getStats() {
            return this.stats;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscoveryResult)) {
                return false;
            }
            DiscoveryResult other = (DiscoveryResult)o;
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            Stats this$stats = this.getStats();
            Stats other$stats = other.getStats();
            return !(this$stats == null ? other$stats != null : !this$stats.equals(other$stats));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            Stats $stats = this.getStats();
            result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EndpointDiscovery.DiscoveryResult(endpoint=" + this.getEndpoint() + ", duration=" + this.getDuration() + ", stats=" + this.getStats() + ")";
        }
    }
}

