/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.AdvancedSearch;
import de.sfuhrm.radiobrowser4j.Limit;
import de.sfuhrm.radiobrowser4j.ListParameter;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.PagingSpliterator;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.RestClientFactory;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiobrowser4j.Stats;
import de.sfuhrm.radiobrowser4j.UrlResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadioBrowser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadioBrowser.class);
    @Deprecated
    protected static final String DEFAULT_API_URL = "https://at1.api.radio-browser.info/";
    private final WebTarget webTarget;
    private final String userAgent;

    public RadioBrowser(@NonNull String apiUrl, int timeout, @NonNull String myUserAgent) {
        this(apiUrl, timeout, myUserAgent, null, null, null);
        if (apiUrl == null) {
            throw new NullPointerException("apiUrl is marked non-null but is null");
        }
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
    }

    public RadioBrowser(@NonNull String apiUrl, int timeout, @NonNull String myUserAgent, String proxyUri, String proxyUser, String proxyPassword) {
        if (apiUrl == null) {
            throw new NullPointerException("apiUrl is marked non-null but is null");
        }
        if (myUserAgent == null) {
            throw new NullPointerException("myUserAgent is marked non-null but is null");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0, but is " + timeout);
        }
        this.userAgent = myUserAgent;
        Client client = RestClientFactory.newClient(timeout, proxyUri, proxyUser, proxyPassword);
        this.webTarget = client.target(apiUrl);
    }

    @Deprecated
    public RadioBrowser(int timeout, String myUserAgent) {
        this(DEFAULT_API_URL, timeout, myUserAgent);
    }

    private Invocation.Builder builder(WebTarget in) {
        return in.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent).header("Accept-Encoding", (Object)"gzip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> retrieveValueStationCountList(String subPath) {
        Map<String, Integer> map;
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(subPath)).post(entity);
            List map2 = (List)response.readEntity((GenericType)new GenericType<List<Map<String, String>>>(){});
            RadioBrowser.checkResponseStatus(response);
            map = map2.stream().collect(Collectors.toMap(m -> (String)m.get("name"), m -> Integer.parseInt((String)m.get("stationcount")), (a, b) -> a));
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return map;
    }

    public Map<String, Integer> listCountries() {
        return this.retrieveValueStationCountList("json/countries");
    }

    public Map<String, Integer> listCodecs() {
        return this.retrieveValueStationCountList("json/codecs");
    }

    public Map<String, Integer> listLanguages() {
        return this.retrieveValueStationCountList("json/languages");
    }

    public Map<String, Integer> listTags() {
        return this.retrieveValueStationCountList("json/tags");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Station> listStationsPathWithPaging(Optional<Paging> paging, String path, ListParameter ... listParam) {
        List list;
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        paging.ifPresent(arg_0 -> RadioBrowser.lambda$listStationsPathWithPaging$3((MultivaluedMap)requestParams, arg_0));
        Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsPathWithPaging$4((MultivaluedMap)requestParams, arg_0));
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(path)).post(entity);
            RadioBrowser.checkResponseStatus(response);
            list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Station> listStationsPathWithLimit(Optional<Limit> limit, String path, ListParameter ... listParam) {
        List list;
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsPathWithLimit$5((MultivaluedMap)requestParams, arg_0));
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            WebTarget target = this.webTarget.path(path);
            if (limit.isPresent()) {
                target = target.path(Integer.toString(limit.get().getSize()));
            }
            response = this.builder(target).post(entity);
            RadioBrowser.checkResponseStatus(response);
            list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return list;
    }

    public List<Station> listStations(@NonNull Paging paging, ListParameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        return this.listStationsPathWithPaging(Optional.of(paging), "json/stations", listParam);
    }

    public Stream<Station> listStations(ListParameter ... listParam) {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStations((Paging)p, listParam)), false);
    }

    public List<Station> listBrokenStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/broken", new ListParameter[0]);
    }

    public Stream<Station> listBrokenStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/broken", new ListParameter[0])), false);
    }

    public List<Station> listImprovableStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return Collections.emptyList();
    }

    @Deprecated
    public Stream<Station> listImprovableStations() {
        return new ArrayList().stream();
    }

    public List<Station> listTopClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topclick", new ListParameter[0]);
    }

    public Stream<Station> listTopClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topclick", new ListParameter[0])), false);
    }

    public List<Station> listTopVoteStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topvote", new ListParameter[0]);
    }

    public Stream<Station> listTopVoteStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topvote", new ListParameter[0])), false);
    }

    public List<Station> listLastClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastclick", new ListParameter[0]);
    }

    public Stream<Station> listLastClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastclick", new ListParameter[0])), false);
    }

    public List<Station> listLastChangedStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastchange", new ListParameter[0]);
    }

    public Stream<Station> listLastChangedStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastchange", new ListParameter[0])), false);
    }

    public Optional<Station> getStationByUUID(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        List<Station> stationList = this.listStationsBy(Paging.at(0, 1), SearchMode.BYUUID, uuid.toString(), new ListParameter[0]);
        if (stationList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(stationList.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Station> listStationsBy(@NonNull Paging paging, @NonNull SearchMode searchMode, @NonNull String searchTerm, ListParameter ... listParam) {
        List list;
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        paging.apply((MultivaluedMap<String, String>)requestParams);
        Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsBy$12((MultivaluedMap)requestParams, arg_0));
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path("json/stations").path(searchMode.name().toLowerCase()).path(searchTerm)).post(entity);
            RadioBrowser.checkResponseStatus(response);
            list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return list;
    }

    public Stream<Station> listStationsBy(@NonNull SearchMode searchMode, @NonNull String searchTerm, ListParameter ... listParam) {
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        Function fetcher = p -> {
            List list;
            MultivaluedHashMap requestParams = new MultivaluedHashMap();
            p.apply((MultivaluedMap<String, String>)requestParams);
            Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsBy$13((MultivaluedMap)requestParams, arg_0));
            Entity entity = Entity.form((MultivaluedMap)requestParams);
            Response response = null;
            try {
                response = this.builder(this.webTarget.path("json/stations").path(searchMode.name().toLowerCase()).path(searchTerm)).post(entity);
                RadioBrowser.checkResponseStatus(response);
                list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
            }
            catch (Throwable throwable) {
                RadioBrowser.close(response);
                throw throwable;
            }
            RadioBrowser.close(response);
            return list;
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher), false);
    }

    /*
     * Loose catch block
     */
    public URL resolveStreamUrl(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        Response response = null;
        response = this.builder(this.webTarget.path("json/url").path(stationUUID.toString())).get();
        RadioBrowser.checkResponseStatus(response);
        log.debug("URI is {}", (Object)this.webTarget.getUri());
        UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
        URL uRL = new URL(urlResponse.getUrl());
        RadioBrowser.close(response);
        return uRL;
        {
            catch (MalformedURLException e) {
                try {
                    throw new RadioBrowserException(e);
                }
                catch (Throwable throwable) {
                    RadioBrowser.close(response);
                    throw throwable;
                }
            }
        }
    }

    public UUID postNewStation(@NonNull Station station) {
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        return this.postNewOrEditStation(station, "json/add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void voteForStation(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        Response response = null;
        try {
            response = this.builder(this.webTarget.path("json/vote/").path(stationUUID.toString())).get();
            RadioBrowser.logResponseStatus(response);
            UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
    }

    public Stats getServerStats() {
        Response response = this.builder(this.webTarget.path("json/stats")).get();
        RadioBrowser.checkResponseStatus(response);
        return (Stats)response.readEntity(Stats.class);
    }

    public Stream<Station> listStationsWithAdvancedSearch(@NonNull AdvancedSearch advancedSearch) {
        if (advancedSearch == null) {
            throw new NullPointerException("advancedSearch is marked non-null but is null");
        }
        Function fetcher = p -> {
            List list;
            MultivaluedHashMap requestParams = new MultivaluedHashMap();
            p.apply((MultivaluedMap<String, String>)requestParams);
            advancedSearch.apply((MultivaluedMap<String, String>)requestParams);
            Entity entity = Entity.form((MultivaluedMap)requestParams);
            Response response = null;
            try {
                response = this.builder(this.webTarget.path("/json/stations/search")).post(entity);
                RadioBrowser.checkResponseStatus(response);
                list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
            }
            catch (Throwable throwable) {
                RadioBrowser.close(response);
                throw throwable;
            }
            RadioBrowser.close(response);
            return list;
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID postNewOrEditStation(@NonNull Station station, String path) {
        UUID uUID;
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        station.apply((MultivaluedMap<String, String>)requestParams);
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(path)).post(entity);
            RadioBrowser.logResponseStatus(response);
            UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
            if (log.isDebugEnabled()) {
                log.debug("Result: {}", (Object)urlResponse);
            }
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
            uUID = urlResponse.getUuid();
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return uUID;
    }

    private static void logResponseStatus(Response response) {
        if (response.getStatus() != 200) {
            log.warn("Non HTTP OK/200 status: status={}, reason={}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
        } else {
            log.debug("HTTP response status={}, reason={}, length={}", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase(), response.getLength()});
        }
    }

    private static void checkResponseStatus(Response response) {
        RadioBrowser.logResponseStatus(response);
        if (response.getStatus() != 200) {
            throw new RadioBrowserException(response.getStatusInfo().getReasonPhrase());
        }
    }

    private static void close(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private static /* synthetic */ void lambda$listStationsBy$13(MultivaluedMap requestParams, ListParameter l) {
        l.apply((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsBy$12(MultivaluedMap requestParams, ListParameter l) {
        l.apply((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsPathWithLimit$5(MultivaluedMap requestParams, ListParameter lp) {
        lp.apply((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsPathWithPaging$4(MultivaluedMap requestParams, ListParameter lp) {
        lp.apply((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsPathWithPaging$3(MultivaluedMap requestParams, Paging p) {
        p.apply((MultivaluedMap<String, String>)requestParams);
    }
}

