/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Station {
    private String id;
    private String name;
    private String url;
    private String homepage;
    private String favicon;
    @JsonIgnore
    private List<String> tagList = new ArrayList<String>();
    private String country;
    private String state;
    private String language;
    private String votes;
    private String negativevotes;
    private String codec;
    private String bitrate;
    private String hls;
    private int lastcheckok;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastchecktime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastcheckoktime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date clicktimestamp;
    private String clickcount;
    private String clicktrend;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastchangetime;

    @JsonGetter(value="tags")
    public String getTags() {
        return this.tagList.stream().collect(Collectors.joining(","));
    }

    @JsonSetter(value="tags")
    public void setTags(String commaTags) {
        this.tagList = Arrays.asList(commaTags.split(","));
    }

    public String toString() {
        return "Station{name=" + this.name + ", url=" + this.url + '}';
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Station)) {
            return false;
        }
        Station other = (Station)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public String getHomepage() {
        return this.homepage;
    }

    @Generated
    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    @Generated
    public String getFavicon() {
        return this.favicon;
    }

    @Generated
    public void setFavicon(String favicon) {
        this.favicon = favicon;
    }

    @Generated
    public List<String> getTagList() {
        return this.tagList;
    }

    @Generated
    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public String getVotes() {
        return this.votes;
    }

    @Generated
    public void setVotes(String votes) {
        this.votes = votes;
    }

    @Generated
    public String getNegativevotes() {
        return this.negativevotes;
    }

    @Generated
    public void setNegativevotes(String negativevotes) {
        this.negativevotes = negativevotes;
    }

    @Generated
    public String getCodec() {
        return this.codec;
    }

    @Generated
    public void setCodec(String codec) {
        this.codec = codec;
    }

    @Generated
    public String getBitrate() {
        return this.bitrate;
    }

    @Generated
    public void setBitrate(String bitrate) {
        this.bitrate = bitrate;
    }

    @Generated
    public String getHls() {
        return this.hls;
    }

    @Generated
    public void setHls(String hls) {
        this.hls = hls;
    }

    @Generated
    public int getLastcheckok() {
        return this.lastcheckok;
    }

    @Generated
    public void setLastcheckok(int lastcheckok) {
        this.lastcheckok = lastcheckok;
    }

    @Generated
    public Date getLastchecktime() {
        return this.lastchecktime;
    }

    @Generated
    public void setLastchecktime(Date lastchecktime) {
        this.lastchecktime = lastchecktime;
    }

    @Generated
    public Date getLastcheckoktime() {
        return this.lastcheckoktime;
    }

    @Generated
    public void setLastcheckoktime(Date lastcheckoktime) {
        this.lastcheckoktime = lastcheckoktime;
    }

    @Generated
    public Date getClicktimestamp() {
        return this.clicktimestamp;
    }

    @Generated
    public void setClicktimestamp(Date clicktimestamp) {
        this.clicktimestamp = clicktimestamp;
    }

    @Generated
    public String getClickcount() {
        return this.clickcount;
    }

    @Generated
    public void setClickcount(String clickcount) {
        this.clickcount = clickcount;
    }

    @Generated
    public String getClicktrend() {
        return this.clicktrend;
    }

    @Generated
    public void setClicktrend(String clicktrend) {
        this.clicktrend = clicktrend;
    }

    @Generated
    public Date getLastchangetime() {
        return this.lastchangetime;
    }

    @Generated
    public void setLastchangetime(Date lastchangetime) {
        this.lastchangetime = lastchangetime;
    }
}

