/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.Paging;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagingSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagingSpliterator.class);
    private static final int FETCH_SIZE_DEFAULT = 32;
    private Paging currentPage = Paging.at(0, 32);
    private List<T> currentData;
    private int pageIndex = 0;
    private final Function<Paging, List<T>> fetchPage;

    PagingSpliterator(Function<Paging, List<T>> fetchPageFunction) {
        super(Long.MAX_VALUE, 0);
        this.fetchPage = fetchPageFunction;
        this.loadPage();
    }

    private void loadPage() {
        log.debug("Loading page {}", (Object)this.currentPage);
        this.currentData = this.fetchPage.apply(this.currentPage);
        log.debug("Elements in loaded page: {}", (Object)this.currentData.size());
        this.pageIndex = 0;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.pageIndex >= this.currentData.size()) {
            this.currentPage = this.currentPage.next();
            this.loadPage();
        }
        if (this.pageIndex < this.currentData.size()) {
            T element = this.currentData.get(this.pageIndex);
            action.accept(element);
            ++this.pageIndex;
            return true;
        }
        return false;
    }
}

