/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.ListParameter;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.PagingSpliterator;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiobrowser4j.UrlResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RadioBrowser {
    private static final Logger log = LoggerFactory.getLogger(RadioBrowser.class);
    protected static final String API_URL = "http://www.radio-browser.info/webservice/";
    private final WebTarget webTarget;
    private final String userAgent;

    RadioBrowser(String apiUrl, int timeout, String myUserAgent) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0, but is " + timeout);
        }
        this.userAgent = Objects.requireNonNull(myUserAgent, "User agent is null");
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();
        client.property("jersey.config.client.connectTimeout", (Object)timeout);
        client.property("jersey.config.client.readTimeout", (Object)timeout);
        this.webTarget = client.target(apiUrl);
    }

    public RadioBrowser(int timeout, String myUserAgent) {
        this(API_URL, timeout, myUserAgent);
    }

    private Invocation.Builder builder(WebTarget in) {
        return in.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.userAgent);
    }

    private static void applyPaging(Paging paging, MultivaluedMap<String, String> requestParams) {
        Objects.requireNonNull(paging, "Paging must be non-null");
        log.info("paging={}", (Object)paging);
        requestParams.put((Object)"limit", Collections.singletonList(Integer.toString(paging.getLimit())));
        requestParams.put((Object)"offset", Collections.singletonList(Integer.toString(paging.getOffset())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> retrieveValueStationCountList(String subpath) {
        Map<String, Integer> map;
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(subpath)).post(entity);
            List map2 = (List)response.readEntity((GenericType)new GenericType<List<Map<String, String>>>(){});
            RadioBrowser.checkResponseStatus(response);
            map = map2.stream().collect(Collectors.toMap(m -> (String)m.get("value"), m -> Integer.parseInt((String)m.get("stationcount"))));
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return map;
    }

    public Map<String, Integer> listCountries() {
        return this.retrieveValueStationCountList("json/countries");
    }

    public Map<String, Integer> listCodecs() {
        return this.retrieveValueStationCountList("json/codecs");
    }

    public Map<String, Integer> listLanguages() {
        return this.retrieveValueStationCountList("json/languages");
    }

    public Map<String, Integer> listTags() {
        return this.retrieveValueStationCountList("json/tags");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Station> listStationsPath(Optional<Paging> paging, String path, ListParameter ... listParam) {
        List list;
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        paging.ifPresent(arg_0 -> RadioBrowser.lambda$listStationsPath$2((MultivaluedMap)requestParams, arg_0));
        Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsPath$3((MultivaluedMap)requestParams, arg_0));
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(path)).post(entity);
            RadioBrowser.checkResponseStatus(response);
            list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return list;
    }

    public List<Station> listStations(Paging paging, ListParameter ... listParam) {
        return this.listStationsPath(Optional.of(paging), "json/stations", listParam);
    }

    public Stream<Station> listStations(ListParameter ... listParam) {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStations((Paging)p, listParam)), false);
    }

    public List<Station> listBrokenStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/broken", new ListParameter[0]);
    }

    public Stream<Station> listBrokenStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/broken", new ListParameter[0])), false);
    }

    public List<Station> listImprovableStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/improvable", new ListParameter[0]);
    }

    public Stream<Station> listImprovableStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/improvable", new ListParameter[0])), false);
    }

    public List<Station> listTopClickStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/topclick", new ListParameter[0]);
    }

    public Stream<Station> listTopClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/topclick", new ListParameter[0])), false);
    }

    public List<Station> listTopVoteStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/topvote", new ListParameter[0]);
    }

    public Stream<Station> listTopVoteStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/topvote", new ListParameter[0])), false);
    }

    public List<Station> listLastClickStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/lastclick", new ListParameter[0]);
    }

    public Stream<Station> listLastClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/lastclick", new ListParameter[0])), false);
    }

    public List<Station> listLastChangedStations(Paging paging) {
        return this.listStationsPath(Optional.of(paging), "json/stations/lastchange", new ListParameter[0]);
    }

    public Stream<Station> listLastChangedStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPath(Optional.of(p), "json/stations/lastchange", new ListParameter[0])), false);
    }

    public List<Station> listDeletedStations() {
        return this.listStationsPath(Optional.empty(), "json/stations/deleted", new ListParameter[0]);
    }

    public Optional<Station> getStationById(String id) {
        Objects.requireNonNull(id, "id must be non-null");
        List<Station> stationList = this.listStationsBy(Paging.at(0, 1), SearchMode.byid, id, new ListParameter[0]);
        if (stationList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(stationList.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Station> listStationsBy(Paging paging, SearchMode searchMode, String searchTerm, ListParameter ... listParam) {
        List list;
        Objects.requireNonNull(searchMode, "searchMode must be non-null");
        Objects.requireNonNull(searchTerm, "searchTerm must be non-null");
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        RadioBrowser.applyPaging(paging, (MultivaluedMap<String, String>)requestParams);
        Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsBy$11((MultivaluedMap)requestParams, arg_0));
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path("json/stations").path(searchMode.name()).path(searchTerm)).post(entity);
            RadioBrowser.checkResponseStatus(response);
            list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return list;
    }

    public Stream<Station> listStationsBy(SearchMode searchMode, String searchTerm, ListParameter ... listParam) {
        Objects.requireNonNull(searchMode, "searchMode must be non-null");
        Objects.requireNonNull(searchTerm, "searchTerm must be non-null");
        Function fetcher = p -> {
            List list;
            MultivaluedHashMap requestParams = new MultivaluedHashMap();
            RadioBrowser.applyPaging(p, (MultivaluedMap<String, String>)requestParams);
            Arrays.stream(listParam).forEach(arg_0 -> RadioBrowser.lambda$listStationsBy$12((MultivaluedMap)requestParams, arg_0));
            Entity entity = Entity.form((MultivaluedMap)requestParams);
            Response response = null;
            try {
                response = this.builder(this.webTarget.path("json/stations").path(searchMode.name()).path(searchTerm)).post(entity);
                RadioBrowser.checkResponseStatus(response);
                list = (List)response.readEntity((GenericType)new GenericType<List<Station>>(){});
            }
            catch (Throwable throwable) {
                RadioBrowser.close(response);
                throw throwable;
            }
            RadioBrowser.close(response);
            return list;
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher), false);
    }

    /*
     * Loose catch block
     */
    public URL resolveStreamUrl(Station station) {
        Objects.requireNonNull(station, "station must be non-null");
        Response response = null;
        response = this.builder(this.webTarget.path("v2/json/url").path(station.getId())).get();
        RadioBrowser.checkResponseStatus(response);
        log.debug("URI is {}", (Object)this.webTarget.getUri());
        UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
        URL uRL = new URL(urlResponse.getUrl());
        RadioBrowser.close(response);
        return uRL;
        {
            catch (MalformedURLException e) {
                try {
                    throw new RadioBrowserException(e);
                }
                catch (Throwable throwable) {
                    RadioBrowser.close(response);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerStationState(Station station, String path) {
        Objects.requireNonNull(station, "station must be non-null");
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(path).path(station.getId())).post(entity);
            RadioBrowser.logResponseStatus(response);
            UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
    }

    public void deleteStation(Station station) {
        this.triggerStationState(station, "json/delete");
    }

    public void undeleteStation(Station station) {
        this.triggerStationState(station, "json/undelete");
    }

    public String postNewStation(Station station) {
        return this.postNewOrEditStation(station, "json/add");
    }

    public String editStation(Station station) {
        Objects.requireNonNull(station.getId(), "id must be non-null");
        return this.postNewOrEditStation(station, "json/edit/" + station.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postNewOrEditStation(Station station, String path) {
        String string;
        Objects.requireNonNull(station, "station must be non-null");
        MultivaluedHashMap requestParams = new MultivaluedHashMap();
        RadioBrowser.transferToMultivaluedMap(station, (MultivaluedMap<String, String>)requestParams);
        Entity entity = Entity.form((MultivaluedMap)requestParams);
        Response response = null;
        try {
            response = this.builder(this.webTarget.path(path)).post(entity);
            RadioBrowser.logResponseStatus(response);
            UrlResponse urlResponse = (UrlResponse)response.readEntity(UrlResponse.class);
            if (log.isDebugEnabled()) {
                log.debug("Result: {}", (Object)urlResponse);
            }
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
            string = urlResponse.getId();
        }
        catch (Throwable throwable) {
            RadioBrowser.close(response);
            throw throwable;
        }
        RadioBrowser.close(response);
        return string;
    }

    private static void transferToMultivaluedMap(Station sourceStation, MultivaluedMap<String, String> targetParams) {
        targetParams.put((Object)"name", Collections.singletonList(sourceStation.getName()));
        targetParams.put((Object)"url", Collections.singletonList(sourceStation.getUrl()));
        if (sourceStation.getHomepage() != null) {
            targetParams.put((Object)"homepage", Collections.singletonList(sourceStation.getHomepage()));
        }
        if (sourceStation.getFavicon() != null) {
            targetParams.put((Object)"favicon", Collections.singletonList(sourceStation.getFavicon()));
        }
        if (sourceStation.getCountry() != null) {
            targetParams.put((Object)"country", Collections.singletonList(sourceStation.getCountry()));
        }
        if (sourceStation.getState() != null) {
            targetParams.put((Object)"state", Collections.singletonList(sourceStation.getState()));
        }
        if (sourceStation.getLanguage() != null) {
            targetParams.put((Object)"language", Collections.singletonList(sourceStation.getLanguage()));
        }
        if (sourceStation.getTags() != null) {
            targetParams.put((Object)"tagList", Collections.singletonList(sourceStation.getTags()));
        }
    }

    private static void logResponseStatus(Response response) {
        if (response.getStatus() != 200) {
            log.warn("Non HTTP OK/200 status: status={}, reason={}", (Object)response.getStatus(), (Object)response.getStatusInfo().getReasonPhrase());
        } else {
            log.debug("HTTP response status={}, reason={}, length={}", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase(), response.getLength()});
        }
    }

    private static void checkResponseStatus(Response response) {
        RadioBrowser.logResponseStatus(response);
        if (response.getStatus() != 200) {
            throw new RadioBrowserException(response.getStatusInfo().getReasonPhrase());
        }
    }

    private static void close(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private static /* synthetic */ void lambda$listStationsBy$12(MultivaluedMap requestParams, ListParameter l) {
        l.applyTo((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsBy$11(MultivaluedMap requestParams, ListParameter l) {
        l.applyTo((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsPath$3(MultivaluedMap requestParams, ListParameter lp) {
        lp.applyTo((MultivaluedMap<String, String>)requestParams);
    }

    private static /* synthetic */ void lambda$listStationsPath$2(MultivaluedMap requestParams, Paging p) {
        RadioBrowser.applyPaging(p, (MultivaluedMap<String, String>)requestParams);
    }
}

