/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Station {
    private String id;
    private String name;
    private String url;
    private String homepage;
    private String favicon;
    @JsonIgnore
    private List<String> tagList = new ArrayList<String>();
    private String country;
    private String state;
    private String language;
    private String votes;
    private String negativevotes;
    private String codec;
    private String bitrate;
    private String hls;
    private int lastcheckok;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastchecktime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastcheckoktime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date clicktimestamp;
    private String clickcount;
    private String clicktrend;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd hh:mm:ss")
    private Date lastchangetime;

    @JsonGetter(value="tags")
    public String getTags() {
        return this.tagList.stream().collect(Collectors.joining(","));
    }

    @JsonSetter(value="tags")
    public void setTags(String commaTags) {
        this.tagList = Arrays.asList(commaTags.split(","));
    }

    public String toString() {
        return "Station{name=" + this.name + ", url=" + this.url + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Station)) {
            return false;
        }
        Station other = (Station)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getFavicon() {
        return this.favicon;
    }

    public void setFavicon(String favicon) {
        this.favicon = favicon;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getVotes() {
        return this.votes;
    }

    public void setVotes(String votes) {
        this.votes = votes;
    }

    public String getNegativevotes() {
        return this.negativevotes;
    }

    public void setNegativevotes(String negativevotes) {
        this.negativevotes = negativevotes;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(String bitrate) {
        this.bitrate = bitrate;
    }

    public String getHls() {
        return this.hls;
    }

    public void setHls(String hls) {
        this.hls = hls;
    }

    public int getLastcheckok() {
        return this.lastcheckok;
    }

    public void setLastcheckok(int lastcheckok) {
        this.lastcheckok = lastcheckok;
    }

    public Date getLastchecktime() {
        return this.lastchecktime;
    }

    public void setLastchecktime(Date lastchecktime) {
        this.lastchecktime = lastchecktime;
    }

    public Date getLastcheckoktime() {
        return this.lastcheckoktime;
    }

    public void setLastcheckoktime(Date lastcheckoktime) {
        this.lastcheckoktime = lastcheckoktime;
    }

    public Date getClicktimestamp() {
        return this.clicktimestamp;
    }

    public void setClicktimestamp(Date clicktimestamp) {
        this.clicktimestamp = clicktimestamp;
    }

    public String getClickcount() {
        return this.clickcount;
    }

    public void setClickcount(String clickcount) {
        this.clickcount = clickcount;
    }

    public String getClicktrend() {
        return this.clicktrend;
    }

    public void setClicktrend(String clicktrend) {
        this.clicktrend = clicktrend;
    }

    public Date getLastchangetime() {
        return this.lastchangetime;
    }

    public void setLastchangetime(Date lastchangetime) {
        this.lastchangetime = lastchangetime;
    }
}

