/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.NativeLoader;
import de.sfuhrm.openssl4j.PhantomReferenceCleanup;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigestSpi;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class OpenSSLMessageDigestNative
extends MessageDigestSpi {
    private final ByteBuffer context;
    private final String algorithmName;
    private final int digestLength;

    private static native int digestLength(ByteBuffer var0);

    private static native void removeContext(ByteBuffer var0);

    private static native String[] listMessageDigests();

    private final native ByteBuffer nativeContext();

    private final native void nativeInit(ByteBuffer var1, String var2);

    private final native void nativeUpdateWithByte(ByteBuffer var1, byte var2);

    private final native void nativeUpdateWithByteArray(ByteBuffer var1, byte[] var2, int var3, int var4);

    private final native void nativeUpdateWithByteBuffer(ByteBuffer var1, ByteBuffer var2, int var3, int var4);

    private final native void nativeFinal(ByteBuffer var1, byte[] var2);

    OpenSSLMessageDigestNative(String openSslName) {
        try {
            NativeLoader.loadAll();
            this.algorithmName = Objects.requireNonNull(openSslName);
            this.context = this.nativeContext();
            PhantomReferenceCleanup.enqueueForCleanup(this, OpenSSLMessageDigestNative::free, this.context);
            this.engineReset();
            this.digestLength = OpenSSLMessageDigestNative.digestLength(this.context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static void free(ByteBuffer context) {
        Objects.requireNonNull(context);
        if (!context.isDirect()) {
            throw new IllegalStateException("Illegal buffer passed in");
        }
        OpenSSLMessageDigestNative.removeContext(context);
    }

    @Override
    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected static Set<String> getMessageDigestList() {
        String[] messageDigestAlgorithms = OpenSSLMessageDigestNative.listMessageDigests();
        HashSet<String> result = new HashSet<String>(Arrays.asList(messageDigestAlgorithms));
        return result;
    }

    @Override
    protected final void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        int remaining = input.remaining();
        int offset = input.position();
        if (input.isDirect()) {
            this.nativeUpdateWithByteBuffer(this.context, input, offset, remaining);
            input.position(input.position() + remaining);
        } else if (input.hasArray()) {
            byte[] array = input.array();
            this.nativeUpdateWithByteArray(this.context, array, offset, remaining);
            input.position(offset + remaining);
        } else {
            byte[] array = new byte[remaining];
            input.get(array);
            this.nativeUpdateWithByteArray(this.context, array, 0, array.length);
        }
    }

    @Override
    protected final void engineUpdate(byte inputByte) {
        this.nativeUpdateWithByte(this.context, inputByte);
    }

    @Override
    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.nativeUpdateWithByteArray(this.context, input, offset, len);
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] result = new byte[this.digestLength];
        this.nativeFinal(this.context, result);
        this.engineReset();
        return result;
    }

    @Override
    protected final void engineReset() {
        this.nativeInit(this.context, this.algorithmName);
    }
}

