/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

final class ObjectTransfer {
    private final Path targetDirectory = Files.createTempDirectory("native", new FileAttribute[0]);
    private final List<Path> libraries = new ArrayList<Path>();

    ObjectTransfer() throws IOException {
        Runnable removeTarget = () -> {
            for (Path p : this.libraries) {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Files.delete(this.targetDirectory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(removeTarget));
    }

    private static String getOsName() {
        return System.getProperty("os.name");
    }

    private static String getArchName() {
        return System.getProperty("os.arch");
    }

    static String toLibraryName(String name) {
        return name + "-" + ObjectTransfer.getOsName() + "-" + ObjectTransfer.getArchName() + ".so";
    }

    final List<Path> getObjectFiles() {
        return Collections.unmodifiableList(this.libraries);
    }

    final void transfer(String ... names) throws IOException {
        block14: {
            int n = 0;
            String[] stringArray = names;
            int n2 = stringArray.length;
            if (n < n2) {
                InputStream inputStream;
                Path targetLibraryPath;
                String libName;
                block13: {
                    String name = stringArray[n];
                    libName = ObjectTransfer.toLibraryName(name);
                    targetLibraryPath = this.targetDirectory.resolve(libName);
                    inputStream = this.getClass().getResourceAsStream("/objects/" + libName);
                    try {
                        if (inputStream == null) break block13;
                        this.transferTo(inputStream, targetLibraryPath);
                        break block14;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                inputStream = Files.newInputStream(Paths.get("src/main/resources/objects", new String[0]).resolve(libName), new OpenOption[0]);
                try {
                    this.transferTo(inputStream, targetLibraryPath);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }

    private void transferTo(InputStream inputStream, Path targetFile) throws IOException {
        Files.copy(inputStream, targetFile, new CopyOption[0]);
        HashSet<PosixFilePermission> set = new HashSet<PosixFilePermission>();
        set.add(PosixFilePermission.OWNER_EXECUTE);
        set.add(PosixFilePermission.OWNER_READ);
        Files.setPosixFilePermissions(targetFile, set);
        this.libraries.add(targetFile);
    }
}

