/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.MessageDigest;
import de.sfuhrm.openssl4j.NativeLoader;
import de.sfuhrm.openssl4j.OpenSSLMessageDigestNative;
import de.sfuhrm.openssl4j.PropertyAccessor;
import java.io.IOException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OpenSSL4JProvider
extends Provider {
    public static final String PROVIDER_NAME = "OpenSSL4J";
    private static Set<String> openSslMessageDigestAlgorithms;
    private static final String[] SSL_TO_JAVA_NAMES;

    public OpenSSL4JProvider() {
        super(PROVIDER_NAME, OpenSSL4JProvider.getLibraryVersion(), "OpenSSL4J provider v" + PropertyAccessor.get("version", "unknown") + ", implementing multiple message digest algorithms.");
        try {
            NativeLoader.loadAll();
            if (openSslMessageDigestAlgorithms == null) {
                openSslMessageDigestAlgorithms = OpenSSLMessageDigestNative.getMessageDigestList();
            }
            Map<String, String> names = OpenSSL4JProvider.getNames(openSslMessageDigestAlgorithms);
            this.putAll(names);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize", e);
        }
    }

    private static double getLibraryVersion() {
        double result = 0.0;
        String stringVersion = PropertyAccessor.get("version", "0.0.0");
        Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+).*");
        Matcher matcher = versionPattern.matcher(stringVersion);
        if (matcher.matches()) {
            result = Double.parseDouble(matcher.group(1));
        }
        return result;
    }

    private static Map<String, String> getNames(Set<String> availableOpenSslAlgorithmNames) {
        Map<String, String> result = OpenSSL4JProvider.getOpenSSLHashnames(availableOpenSslAlgorithmNames);
        result.putAll(OpenSSL4JProvider.createAliases(result));
        return result;
    }

    private static Map<String, String> createAliases(Map<String, String> map) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("([^0-9]*)-([0-9]+)");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            aliases.put(matcher.group(1) + matcher.group(2), entry.getValue());
        }
        aliases.put("MessageDigest.SHA", map.get("MessageDigest.SHA1"));
        return aliases;
    }

    private static Map<String, String> getOpenSSLHashnames(Set<String> availableOpenSslAlgos) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < SSL_TO_JAVA_NAMES.length; i += 2) {
            String sslName = SSL_TO_JAVA_NAMES[i];
            String javaName = SSL_TO_JAVA_NAMES[i + 1];
            if (!availableOpenSslAlgos.contains(sslName)) continue;
            String javaClass = MessageDigest.class.getName() + "$" + javaName.replaceAll("-", "_").replaceAll("/", "_");
            map.put("MessageDigest." + javaName, javaClass);
        }
        return map;
    }

    static {
        SSL_TO_JAVA_NAMES = new String[]{"MD5", "MD5", "SHA1", "SHA1", "SHA224", "SHA-224", "SHA256", "SHA-256", "SHA384", "SHA-384", "SHA512", "SHA-512", "SHA512-224", "SHA-512/224", "SHA512-256", "SHA-512/256", "SHA3-224", "SHA3-224", "SHA3-256", "SHA3-256", "SHA3-384", "SHA3-384", "SHA3-512", "SHA3-512", "BLAKE2b512", "BLAKE2b512", "BLAKE2s256", "BLAKE2s256", "MD4", "MD4", "RIPEMD160", "RIPEMD160", "SM3", "SM3", "whirlpool", "Whirlpool"};
    }
}

