/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.OpenSSLMessageDigestNative;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class PhantomReferenceCleanup {
    private static final ReferenceQueue<OpenSSLMessageDigestNative> BYTE_BUFFER_REFERENCE_QUEUE = new ReferenceQueue();
    private static boolean running = false;
    private static final Set<NativePhantomReference> nativePhantomReferenceList = Collections.synchronizedSet(new HashSet());

    PhantomReferenceCleanup() {
    }

    static void enqueueForCleanup(OpenSSLMessageDigestNative ref) {
        NativePhantomReference phantomReference = new NativePhantomReference(ref, ref.getContext());
        nativePhantomReferenceList.add(phantomReference);
        PhantomReferenceCleanup.startIfNeeded();
    }

    static synchronized void startIfNeeded() {
        if (!running) {
            running = true;
            Runnable r = () -> {
                try {
                    while (true) {
                        NativePhantomReference reference = (NativePhantomReference)BYTE_BUFFER_REFERENCE_QUEUE.remove();
                        reference.free();
                        nativePhantomReferenceList.remove(reference);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            };
            Thread t = new Thread(r, "OpenSSL-Cleanup");
            t.setDaemon(true);
            t.start();
        }
    }

    private static class NativePhantomReference
    extends PhantomReference<OpenSSLMessageDigestNative> {
        private final ByteBuffer byteBuffer;

        NativePhantomReference(OpenSSLMessageDigestNative abstractNative, ByteBuffer context) {
            super(abstractNative, BYTE_BUFFER_REFERENCE_QUEUE);
            this.byteBuffer = context;
        }

        public void free() {
            OpenSSLMessageDigestNative.removeContext(this.byteBuffer);
        }
    }
}

