/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.NativeLoader;
import de.sfuhrm.openssl4j.OpenSSL;
import de.sfuhrm.openssl4j.OpenSSLMessageDigestNative;
import java.io.IOException;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenSSLProvider
extends Provider {
    private static final String VERSION = "0.1";
    public static final String PROVIDER_NAME = "OpenSSL";
    private static Set<String> openSslMessageDigestAlgorithms;
    private static String[] SSL_TO_JAVA_NAMES;

    public OpenSSLProvider() throws IOException {
        super(PROVIDER_NAME, VERSION, "OpenSSL4J provider v0.1, implementing multiple message digest algorithms.");
        NativeLoader.loadAll();
        if (openSslMessageDigestAlgorithms == null) {
            openSslMessageDigestAlgorithms = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(OpenSSLMessageDigestNative.listMessageDigests())));
        }
        Map<String, String> names = OpenSSLProvider.getNames(openSslMessageDigestAlgorithms);
        this.putAll(names);
    }

    private static Map<String, String> getNames(Set<String> available) {
        Map<String, String> result = OpenSSLProvider.getOpenSSLHashnames(available);
        result.putAll(OpenSSLProvider.createAliases(result));
        return result;
    }

    private static Map<String, String> createAliases(Map<String, String> map) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("([^0-9]*)([0-9]+)");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            aliases.put(matcher.group(1) + "-" + matcher.group(2), entry.getValue());
        }
        return aliases;
    }

    private static Map<String, String> getOpenSSLHashnames(Set<String> available) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < SSL_TO_JAVA_NAMES.length; i += 2) {
            String sslName = SSL_TO_JAVA_NAMES[i + 0];
            String javaName = SSL_TO_JAVA_NAMES[i + 1];
            if (!available.contains(sslName)) continue;
            String javaClass = OpenSSL.class.getName() + "$" + javaName.replaceAll("-", "_").replaceAll("/", "_");
            map.put("MessageDigest." + javaName, javaClass);
        }
        return map;
    }

    static {
        SSL_TO_JAVA_NAMES = new String[]{"MD5", "MD5", "SHA1", "SHA1", "SHA224", "SHA-224", "SHA256", "SHA-256", "SHA384", "SHA-384", "SHA512", "SHA-512", "SHA512-224", "SHA-512/224", "SHA512-256", "SHA-512/256", "SHA3-224", "SHA3-224", "SHA3-256", "SHA3-256", "SHA3-384", "SHA3-384", "SHA3-512", "SHA3-512", "SHA3-512", "SHA3-512", "BLAKE2b512", "BLAKE2b512", "BLAKE2s256", "BLAKE2s256", "MD4", "MD4", "RIPEMD160", "RIPEMD160", "SM3", "SM3", "whirlpool", "Whirlpool"};
    }
}

