/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.NativeLoader;
import de.sfuhrm.openssl4j.PhantomReferenceCleanup;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigestSpi;

class OpenSSLMessageDigestNative
extends MessageDigestSpi {
    private final ByteBuffer context;
    private final String algorithmName;

    private static native int digestLength(ByteBuffer var0);

    protected static native void removeContext(ByteBuffer var0);

    protected static final native String[] listMessageDigests();

    private final native ByteBuffer nativeContext();

    private final native void nativeInit(ByteBuffer var1, String var2);

    private final native void nativeUpdateWithByte(ByteBuffer var1, byte var2);

    private final native void nativeUpdateWithByteArray(ByteBuffer var1, byte[] var2, int var3, int var4);

    private final native void nativeUpdateWithByteBuffer(ByteBuffer var1, ByteBuffer var2, int var3, int var4);

    private final native void nativeFinal(ByteBuffer var1, byte[] var2);

    OpenSSLMessageDigestNative(String openSslName) {
        try {
            NativeLoader.loadAll();
            this.algorithmName = openSslName;
            this.context = this.nativeContext();
            PhantomReferenceCleanup.enqueueForCleanup(this);
            this.engineReset();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    final ByteBuffer getContext() {
        return this.context;
    }

    @Override
    protected int engineGetDigestLength() {
        return OpenSSLMessageDigestNative.digestLength(this.context);
    }

    @Override
    protected final void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        int remaining = input.remaining();
        int offset = input.position();
        if (input.isDirect()) {
            this.nativeUpdateWithByteBuffer(this.context, input, offset, remaining);
        } else {
            byte[] array = input.array();
            this.nativeUpdateWithByteArray(this.context, array, 0, array.length);
        }
        input.position(remaining);
    }

    @Override
    protected final void engineUpdate(byte inputByte) {
        this.nativeUpdateWithByte(this.context, inputByte);
    }

    @Override
    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.nativeUpdateWithByteArray(this.context, input, offset, len);
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] result = new byte[OpenSSLMessageDigestNative.digestLength(this.context)];
        this.nativeFinal(this.context, result);
        return result;
    }

    @Override
    protected final void engineReset() {
        this.nativeInit(this.context, this.algorithmName);
    }
}

