/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.maven.assemblyplugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ContainerDescriptorHandler.class, hint="message-digest")
public class MessageDigestContainerDescriptorHandler
implements ContainerDescriptorHandler {
    private final Logger logger = LoggerFactory.getLogger(MessageDigestContainerDescriptorHandler.class);
    private String messageDigest = "MD5";
    private String checksumFile = "MD5SUMS";
    private Pattern exclusionPattern;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & data[i]];
        }
        return out;
    }

    public void setExclusionRegex(String inPattern) {
        this.exclusionPattern = Pattern.compile(inPattern);
        this.logger.debug("Exclusion regex: {}", (Object)this.exclusionPattern);
    }

    public void setMessageDigest(String inDigest) {
        this.messageDigest = inDigest;
        this.logger.debug("Message digest: {}", (Object)this.messageDigest);
    }

    public void setChecksumFile(String inChecksumFile) {
        this.checksumFile = Objects.requireNonNull(inChecksumFile);
        this.logger.debug("Checksum file: {}", (Object)this.checksumFile);
    }

    public void finalizeArchiveCreation(Archiver archiver) {
        HashMap<String, byte[]> messageDigests = new HashMap<String, byte[]>();
        ResourceIterator resourceIterator = archiver.getResources();
        while (resourceIterator.hasNext()) {
            ArchiveEntry archiveEntry = resourceIterator.next();
            this.logger.debug("ArchiveEntry {} is type {}", (Object)archiveEntry.getName(), (Object)archiveEntry.getType());
            boolean skip = 1 != archiveEntry.getType();
            if (skip |= this.exclusionPattern != null && this.exclusionPattern.matcher(archiveEntry.getName()).matches()) {
                this.logger.info("Skipping ArchiveEntry {}", (Object)archiveEntry.getName());
                continue;
            }
            try {
                InputStream inputStream = archiveEntry.getInputStream();
                try {
                    messageDigests.put(archiveEntry.getName(), this.digest(inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.logger.warn("Error processing " + archiveEntry.getName(), (Throwable)e);
                throw new ArchiverException("Error processing " + archiveEntry.getName(), (Throwable)e);
            }
        }
        Path checksumFilePath = this.createChecksumFile(messageDigests);
        File file = checksumFilePath.toFile();
        file.deleteOnExit();
        archiver.addFile(file, this.checksumFile);
    }

    private Path createChecksumFile(Map<String, byte[]> fileCatalog) {
        try {
            Path path = Files.createTempFile("assembly-" + this.messageDigest, ".tmp", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                ArrayList<String> keys = new ArrayList<String>(fileCatalog.keySet());
                keys.sort(String.CASE_INSENSITIVE_ORDER);
                for (String key : keys) {
                    writer.append(new String(MessageDigestContainerDescriptorHandler.encodeHex(fileCatalog.get(key)))).append(" *").append(key).append("\n");
                }
            }
            return path;
        }
        catch (IOException e) {
            this.logger.warn("Error creating temporary file", (Throwable)e);
            throw new ArchiverException("Cannot create temporary file to finalize archive creation", (Throwable)e);
        }
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) {
    }

    public List<String> getVirtualFiles() {
        return Collections.singletonList(this.checksumFile);
    }

    public boolean isSelected(FileInfo fileInfo) {
        return true;
    }

    private MessageDigest newMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.messageDigest);
    }

    private byte[] digest(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int length;
        MessageDigest messageDigestInstance = this.newMessageDigest();
        byte[] buffer = new byte[4096];
        while (-1 != (length = inputStream.read(buffer))) {
            messageDigestInstance.update(buffer, 0, length);
        }
        return messageDigestInstance.digest();
    }
}

