/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import fi.iki.elonen.NanoHTTPD;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class ServerException
extends Exception {
    private NanoHTTPD.Response.Status status;
    private String message;
    private Optional<Consumer<NanoHTTPD.Response>> responseConsumer;

    ServerException(NanoHTTPD.Response.Status inStatus, String inMessage) {
        this(inStatus, inMessage, Optional.empty());
    }

    ServerException(NanoHTTPD.Response.Status inStatus, String inMessage, Optional<Consumer<NanoHTTPD.Response>> inConsumer) {
        super(inMessage);
        this.status = Objects.requireNonNull(inStatus);
        this.message = Objects.requireNonNull(inMessage);
        this.responseConsumer = Objects.requireNonNull(inConsumer);
    }

    public NanoHTTPD.Response toResponse() {
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.status, (String)"text/plain", (String)(this.message + "\r\n"));
        this.responseConsumer.ifPresent(t -> t.accept(response));
        return response;
    }
}

