/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.LogConfigurator;
import java.util.Optional;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;

class Log4j1Configurator
extends LogConfigurator {
    Log4j1Configurator() {
    }

    private static Level parseLevel(String levelString) {
        Level level = Level.toLevel((String)levelString.toUpperCase(), null);
        if (level == null) {
            throw new IllegalArgumentException("Level not recognized: " + levelString);
        }
        return level;
    }

    @Override
    public Optional<LogConfigurator.Resource> findResource(String resource) {
        if (resource == null || resource.isEmpty() || resource.equals("/")) {
            return Optional.of(new RootLoggerResource());
        }
        return Optional.of(new LoggerResource(resource));
    }

    private static class LoggerResource
    implements LogConfigurator.Resource {
        private String logger;

        LoggerResource(String inLogger) {
            this.logger = inLogger;
        }

        @Override
        public String read() {
            return LogManager.getLogger((String)this.logger).getLevel().toString();
        }

        @Override
        public void update(String newLevel) {
            LogManager.getLogger((String)this.logger).setLevel(Log4j1Configurator.parseLevel(newLevel));
        }
    }

    private static class RootLoggerResource
    implements LogConfigurator.Resource {
        private RootLoggerResource() {
        }

        @Override
        public String read() {
            return LogManager.getRootLogger().getLevel().toString();
        }

        @Override
        public void update(String newLevel) {
            LogManager.getRootLogger().setLevel(Log4j1Configurator.parseLevel(newLevel));
        }
    }
}

