/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.Log4j2Configurator;
import de.sfuhrm.logwebconfig.LogConfigurator;
import de.sfuhrm.logwebconfig.ServerException;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Server
extends NanoHTTPD {
    private String username;
    private String password;

    Server(String hostname, int port) throws IOException {
        super(hostname, port);
        this.start(5000, true);
    }

    void setAuthentication(String inUsername, String inPassword) {
        this.username = inUsername;
        this.password = inPassword;
    }

    private void checkAuthentication(NanoHTTPD.IHTTPSession session) throws ServerException {
        if (this.username != null && this.password != null) {
            String auth = (String)session.getHeaders().get("authorization");
            if (auth == null) {
                throw this.unauth();
            }
            int spaceIndex = auth.indexOf(" ");
            if (spaceIndex == -1) {
                throw this.unauth();
            }
            String first = auth.substring(0, spaceIndex);
            if (!first.equals("Basic")) {
                throw this.unauth();
            }
            String base64 = auth.substring(spaceIndex + 1);
            byte[] clientAuthBytes = Base64.getDecoder().decode(base64);
            String clientAuth = new String(clientAuthBytes, Charset.forName("ISO-8859-1"));
            String serverAuth = this.username + ":" + this.password;
            if (!serverAuth.equals(clientAuth)) {
                throw this.unauth();
            }
        }
    }

    private ServerException unauth() {
        return new ServerException(NanoHTTPD.Response.Status.UNAUTHORIZED, "", Optional.of(r -> r.addHeader("WWW-Authenticate", "Basic realm=\"LogWebConfig\"")));
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        try {
            this.checkAuthentication(session);
            NanoHTTPD.Method method = session.getMethod();
            LogConfigurator.Resource resource = this.getResource(session);
            switch (method) {
                case GET: {
                    String level = resource.read();
                    return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)level);
                }
                case PUT: {
                    this.configure(session, resource);
                    break;
                }
                default: {
                    throw new ServerException(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, method.toString());
                }
            }
        }
        catch (ServerException e) {
            return e.toResponse();
        }
        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
    }

    private LogConfigurator.Resource getResource(NanoHTTPD.IHTTPSession session) throws ServerException {
        Log4j2Configurator logConfigurator;
        Pattern pattern = Pattern.compile("/*(log4j2)/([^/]*)/level");
        Matcher matcher = pattern.matcher(session.getUri());
        if (!matcher.matches()) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "URI illegal: " + session.getUri());
        }
        String logFramework = matcher.group(1);
        String logger = matcher.group(2);
        switch (logFramework) {
            case "log4j2": {
                logConfigurator = new Log4j2Configurator();
                break;
            }
            default: {
                throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "Unknown framework " + logFramework);
            }
        }
        Optional<LogConfigurator.Resource> resource = ((LogConfigurator)logConfigurator).findResource(logger);
        if (!resource.isPresent()) {
            throw new ServerException(NanoHTTPD.Response.Status.NOT_FOUND, "Logger not found: " + logger + "'");
        }
        return resource.get();
    }

    private void configure(NanoHTTPD.IHTTPSession session, LogConfigurator.Resource resource) throws ServerException {
        String lengthString = (String)session.getHeaders().get("content-length");
        if (lengthString == null) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "Content-Length header is missing");
        }
        int length = Integer.parseInt(lengthString);
        byte[] data = new byte[length];
        try {
            session.getInputStream().read(data);
        }
        catch (IOException e) {
            throw new ServerException(NanoHTTPD.Response.Status.INTERNAL_ERROR, e.getMessage());
        }
        String levelString = new String(data, Charset.forName("ASCII"));
        if (levelString == null) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "Parameter for level is missing");
        }
        try {
            resource.update(levelString);
        }
        catch (IllegalArgumentException e) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

