/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.Log4j2Configurator;
import de.sfuhrm.logwebconfig.LogConfigurator;
import de.sfuhrm.logwebconfig.ServerException;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Server
extends NanoHTTPD {
    static final String PARAM_LEVEL = "level";

    Server(String hostname, int port) throws IOException {
        super(hostname, port);
        this.start(5000, true);
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        try {
            NanoHTTPD.Method method = session.getMethod();
            LogConfigurator.Resource resource = this.getResource(session);
            switch (method) {
                case GET: {
                    String level = resource.read();
                    return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)level);
                }
                case PUT: {
                    this.configure(session, resource);
                    break;
                }
                default: {
                    throw new ServerException(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, method.toString());
                }
            }
        }
        catch (ServerException e) {
            return e.toResponse();
        }
        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"");
    }

    private LogConfigurator.Resource getResource(NanoHTTPD.IHTTPSession session) throws ServerException {
        Log4j2Configurator logConfigurator;
        Pattern pattern = Pattern.compile("/*(log4j2)/([^/]*)/level");
        Matcher matcher = pattern.matcher(session.getUri());
        if (!matcher.matches()) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "URI illegal: " + session.getUri());
        }
        String logFramework = matcher.group(1);
        String logger = matcher.group(2);
        switch (logFramework) {
            case "log4j2": {
                logConfigurator = new Log4j2Configurator();
                break;
            }
            default: {
                throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "Unknown framework " + logFramework);
            }
        }
        Optional<LogConfigurator.Resource> resource = ((LogConfigurator)logConfigurator).findResource(logger);
        if (!resource.isPresent()) {
            throw new ServerException(NanoHTTPD.Response.Status.NOT_FOUND, "Logger not found: " + logger + "'");
        }
        return resource.get();
    }

    private void configure(NanoHTTPD.IHTTPSession session, LogConfigurator.Resource resource) throws ServerException {
        Map params = session.getParms();
        String levelString = (String)params.get(PARAM_LEVEL);
        if (levelString == null) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, "Parameter 'level' is missing");
        }
        try {
            resource.update(levelString);
        }
        catch (IllegalArgumentException e) {
            throw new ServerException(NanoHTTPD.Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

