/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.Log4j2Configurator;
import de.sfuhrm.logwebconfig.LogConfigurator;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

final class Server
extends NanoHTTPD {
    static final String PARAM_LEVEL = "level";

    Server(String hostname, int port) throws IOException {
        super(hostname, port);
        this.start(5000, true);
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        try {
            NanoHTTPD.Method method = session.getMethod();
            switch (method) {
                case PUT: {
                    return this.configure(session);
                }
            }
            return this.methodNotAllowed(method);
        }
        catch (NanoHTTPD.ResponseException | IOException e) {
            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)e.getMessage());
        }
    }

    private NanoHTTPD.Response configure(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
        Log4j2Configurator logConfigurator;
        Optional<LogConfigurator.Resource> resource;
        String logger = session.getUri();
        Map params = session.getParms();
        String levelString = (String)params.get(PARAM_LEVEL);
        if (levelString == null) {
            return this.badRequest("Parameter 'level' is missing\r\n");
        }
        if (logger.startsWith("/")) {
            logger = logger.substring(1);
        }
        if (!(resource = ((LogConfigurator)(logConfigurator = new Log4j2Configurator())).findResource(logger)).isPresent()) {
            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("Not found: " + logger + "\r\n"));
        }
        try {
            if (resource.isPresent()) {
                resource.get().update(levelString);
            }
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"OK\r\n");
    }

    private NanoHTTPD.Response badRequest(String message) {
        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)message);
    }

    private NanoHTTPD.Response methodNotAllowed(NanoHTTPD.Method method) {
        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, (String)"text/plain", (String)("Method " + method + " is not allowed\r\n"));
    }
}

