/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.Server;
import java.io.IOException;

public final class LogWebConfig {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_PORT = "19293";
    private static final String PROPERTY_PORT = "LOGWEBCONFIG_PORT";
    private static final String PROPERTY_HOST = "LOGWEBCONFIG_HOST";
    private static final String PROPERTY_ENABLE = "LOGWEBCONFIG_ENABLE";
    private static Server singleton;

    private LogWebConfig() {
    }

    public static synchronized void stop() {
        if (singleton == null) {
            return;
        }
        singleton.stop();
        singleton = null;
    }

    public static synchronized void start() {
        if (singleton != null) {
            return;
        }
        String enabled = System.getProperty(PROPERTY_ENABLE);
        if (enabled != null && !Boolean.valueOf(enabled).booleanValue()) {
            return;
        }
        String host = System.getProperty(PROPERTY_HOST, DEFAULT_HOST);
        int port = Integer.parseInt(System.getProperty(PROPERTY_PORT, DEFAULT_PORT));
        try {
            singleton = new Server(host, port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

