/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.logwebconfig;

import de.sfuhrm.logwebconfig.LogConfigurator;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

class Log4j2Configurator
extends LogConfigurator {
    Log4j2Configurator() {
    }

    private static Level parseLevel(String levelString) {
        Level level = Level.getLevel((String)levelString.toUpperCase());
        if (level == null) {
            throw new IllegalArgumentException("Level not recognized: " + levelString);
        }
        return level;
    }

    @Override
    public Optional<LogConfigurator.Resource> findResource(String resource) {
        if (resource == null || resource.isEmpty() || resource.equals("/")) {
            return Optional.of(new RootLoggerResource());
        }
        return Optional.of(new LoggerResource(resource));
    }

    private static class LoggerResource
    implements LogConfigurator.Resource {
        private String logger;

        LoggerResource(String inLogger) {
            this.logger = inLogger;
        }

        @Override
        public String read() {
            return null;
        }

        @Override
        public void update(String newLevel) {
            Configurator.setLevel((String)this.logger, (Level)Log4j2Configurator.parseLevel(newLevel));
        }
    }

    private static class RootLoggerResource
    implements LogConfigurator.Resource {
        private RootLoggerResource() {
        }

        @Override
        public String read() {
            return null;
        }

        @Override
        public void update(String newLevel) {
            Configurator.setRootLevel((Level)Log4j2Configurator.parseLevel(newLevel));
        }
    }
}

