/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.ComputeEngine;
import de.sfuhrm.genetic.Handle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

class SimpleComputeEngine<H>
extends ComputeEngine<H> {
    SimpleComputeEngine(Random inRandom, AlgorithmDefinition<H> inAlgorithmDefinition) {
        super(inRandom, inAlgorithmDefinition);
    }

    @Override
    List<Handle<H>> calculateNextGeneration(List<Handle<H>> currentGeneration, int generationSize, double crossOverRate, double mutationRate) {
        ArrayList<Handle<H>> nextGeneration = new ArrayList<Handle<H>>(generationSize);
        this.updateFitness(currentGeneration);
        this.select(currentGeneration, (int)((1.0 - crossOverRate) * (double)generationSize), nextGeneration);
        this.crossover(currentGeneration, (int)(crossOverRate * (double)generationSize), nextGeneration);
        this.mutate(nextGeneration, (int)(mutationRate * (double)generationSize));
        return nextGeneration;
    }

    @Override
    List<Handle<H>> createRandomHypothesisHandles(int count) {
        ArrayList<Handle<H>> result = new ArrayList<Handle<H>>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new Handle(this.getAlgorithmDefinition().newRandomHypothesis()));
        }
        return result;
    }

    @Override
    void select(List<Handle<H>> population, int targetCount, Collection<Handle<H>> targetCollection) {
        for (int i = 0; i < targetCount; ++i) {
            Handle<H> selected = this.probabilisticSelect(population);
            targetCollection.add(selected);
        }
    }

    @Override
    void crossover(List<Handle<H>> population, int targetCount, Collection<Handle<H>> targetCollection) {
        int i = 0;
        while (i < targetCount) {
            Handle<H> first = this.probabilisticSelect(population);
            Handle<H> second = this.probabilisticSelect(population);
            Collection offsprings = this.getAlgorithmDefinition().crossOverHypothesis(first.getHypothesis(), second.getHypothesis());
            i += offsprings.size();
            for (Object offspring : offsprings) {
                targetCollection.add(new Handle(offspring));
            }
        }
    }

    @Override
    void mutate(List<Handle<H>> selectedSet, int mutationCount) {
        for (int i = 0; i < mutationCount; ++i) {
            int index = this.getRandom().nextInt(selectedSet.size());
            Handle<H> current = selectedSet.get(index);
            Object mutated = this.getAlgorithmDefinition().mutateHypothesis(current.getHypothesis());
            selectedSet.set(index, new Handle(mutated));
        }
    }

    @Override
    void updateFitness(List<Handle<H>> population) {
        double sumFitness = 0.0;
        for (Handle<H> current : population) {
            if (!current.isHasFitness()) {
                current.setFitness(this.getAlgorithmDefinition().calculateFitness(current.getHypothesis()));
            }
            sumFitness += current.getFitness();
        }
        for (Handle<H> current : population) {
            double probability = current.getFitness() / sumFitness;
            current.setProbability(probability);
        }
    }
}

