/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.ComputeEngine;
import de.sfuhrm.genetic.ExecutorServiceComputeEngine;
import de.sfuhrm.genetic.GeneticAlgorithm;
import de.sfuhrm.genetic.SimpleComputeEngine;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;

public class GeneticAlgorithmBuilder<H> {
    private final AlgorithmDefinition<H> algorithmDefinition;
    private Random random;
    public static final double CROSS_OVER_RATE_DEFAULT = 0.3;
    public static final double MUTATION_RATE_DEFAULT = 0.05;
    public static final int GENERATION_SIZE_DEFAULT = 100;
    private double crossOverRate = 0.3;
    private double mutationRate = 0.05;
    private int generationSize = 100;
    private ExecutorService executorService;

    public GeneticAlgorithmBuilder(@NonNull AlgorithmDefinition<H> inAlgorithmDefinition) {
        if (inAlgorithmDefinition == null) {
            throw new NullPointerException("inAlgorithmDefinition is marked non-null but is null");
        }
        this.algorithmDefinition = inAlgorithmDefinition;
    }

    public GeneticAlgorithmBuilder<H> withCrossOverRate(double inRate) {
        if (inRate < 0.0 || inRate > 1.0) {
            throw new IllegalArgumentException("Input must be x >= 0 && x >= 1, but is " + inRate);
        }
        this.crossOverRate = inRate;
        return this;
    }

    public GeneticAlgorithmBuilder<H> withRandom(@NonNull Random inRandom) {
        if (inRandom == null) {
            throw new NullPointerException("inRandom is marked non-null but is null");
        }
        this.random = inRandom;
        return this;
    }

    public GeneticAlgorithmBuilder<H> withExecutorService(@NonNull ExecutorService inExecutorService) {
        if (inExecutorService == null) {
            throw new NullPointerException("inExecutorService is marked non-null but is null");
        }
        this.executorService = inExecutorService;
        return this;
    }

    public GeneticAlgorithmBuilder<H> withMutationRate(double rate) {
        if (rate < 0.0 || rate > 1.0) {
            throw new IllegalArgumentException("Input must be x >= 0 && x >= 1, but is " + rate);
        }
        this.mutationRate = rate;
        return this;
    }

    public GeneticAlgorithmBuilder<H> withGenerationSize(int size) {
        if (size < 2) {
            throw new IllegalArgumentException("Input must be x >= 2, but is " + size);
        }
        this.generationSize = size;
        return this;
    }

    public GeneticAlgorithm<H> build() {
        Random myRandom = this.random != null ? this.random : new Random();
        ComputeEngine myComputeEngine = this.executorService != null ? new ExecutorServiceComputeEngine<H>(myRandom, this.algorithmDefinition, this.executorService) : new SimpleComputeEngine<H>(myRandom, this.algorithmDefinition);
        return new GeneticAlgorithm<H>(this.crossOverRate, this.mutationRate, this.generationSize, this.algorithmDefinition, myComputeEngine, myRandom);
    }
}

