/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.ComputeEngine;
import de.sfuhrm.genetic.Handle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.NonNull;

public class GeneticAlgorithm<H> {
    private final ComputeEngine<H> computeEngine;
    private final AlgorithmDefinition<H> algorithmDefinition;
    private double crossOverRate;
    private double mutationRate;
    private int generationSize;
    private int generationNumber;

    GeneticAlgorithm(double inCrossOverRate, double inMutationRate, int inGenerationSize, @NonNull AlgorithmDefinition<H> inAlgorithmDefinition, @NonNull ComputeEngine<H> inComputeEngine, @NonNull Random inRandom) {
        if (inAlgorithmDefinition == null) {
            throw new NullPointerException("inAlgorithmDefinition is marked non-null but is null");
        }
        if (inComputeEngine == null) {
            throw new NullPointerException("inComputeEngine is marked non-null but is null");
        }
        if (inRandom == null) {
            throw new NullPointerException("inRandom is marked non-null but is null");
        }
        this.crossOverRate = inCrossOverRate;
        this.mutationRate = inMutationRate;
        this.generationSize = inGenerationSize;
        this.algorithmDefinition = Objects.requireNonNull(inAlgorithmDefinition, "inAlgorithmDefinition is null");
        inAlgorithmDefinition.initialize(inRandom);
        this.computeEngine = inComputeEngine;
    }

    private static <H> Optional<Handle<H>> max(Handle<H> a, Handle<H> b) {
        if (a == null) {
            return Optional.ofNullable(b);
        }
        if (b == null) {
            return Optional.of(a);
        }
        if (a.getFitness() > b.getFitness()) {
            return Optional.of(a);
        }
        return Optional.of(b);
    }

    public List<H> calculateNextGeneration(List<H> currentGeneration) {
        List<Handle<H>> nextGeneration = this.innerCalculateNextGeneration(currentGeneration.stream().map(Handle::new).collect(Collectors.toList()));
        return nextGeneration.stream().map(Handle::getHypothesis).collect(Collectors.toList());
    }

    private List<Handle<H>> innerCalculateNextGeneration(List<Handle<H>> currentGeneration) {
        List<Handle<H>> nextGeneration = this.computeEngine.calculateNextGeneration(currentGeneration, this.generationSize, this.crossOverRate, this.mutationRate);
        ++this.generationNumber;
        return nextGeneration;
    }

    private Optional<H> innerFindMaximum() {
        List<Handle<H>> currentGeneration = this.computeEngine.createRandomHypothesisHandles(this.generationSize);
        Optional<Object> allTimeMax = Optional.empty();
        this.generationNumber = 0;
        do {
            List<Handle<H>> nextGeneration = this.innerCalculateNextGeneration(currentGeneration);
            Optional<Handle<H>> curMax = this.computeEngine.max(nextGeneration);
            allTimeMax = GeneticAlgorithm.max(curMax.orElse(null), allTimeMax.orElse(null));
            currentGeneration = nextGeneration;
        } while (allTimeMax.isPresent() && this.algorithmDefinition.loop(((Handle)allTimeMax.get()).getHypothesis()));
        return allTimeMax.map(Handle::getHypothesis);
    }

    public Optional<H> findMaximum() {
        return this.innerFindMaximum();
    }

    public double getCrossOverRate() {
        return this.crossOverRate;
    }

    public void setCrossOverRate(double crossOverRate) {
        this.crossOverRate = crossOverRate;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public int getGenerationSize() {
        return this.generationSize;
    }

    public void setGenerationSize(int generationSize) {
        this.generationSize = generationSize;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }
}

