/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.ComputeEngine;
import de.sfuhrm.genetic.Handle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class ExecutorServiceComputeEngine<H>
extends ComputeEngine<H> {
    private final ExecutorService executorService;

    ExecutorServiceComputeEngine(Random inRandom, AlgorithmDefinition<H> inDefinition, ExecutorService inExecutorService) {
        super(inRandom, inDefinition);
        this.executorService = inExecutorService;
    }

    private void handleException(Exception exception) {
        throw new RuntimeException(exception);
    }

    @Override
    List<Handle<H>> calculateNextGeneration(List<Handle<H>> currentGeneration, int generationSize, double crossOverRate, double mutationRate) {
        ArrayList<Handle<H>> nextGeneration = new ArrayList<Handle<H>>(generationSize);
        this.updateFitness(currentGeneration);
        Future<List> selectionFuture = this.executorService.submit(() -> {
            int selectionSize = (int)((1.0 - crossOverRate) * (double)generationSize);
            ArrayList<Handle<H>> result = new ArrayList<Handle<H>>(selectionSize);
            this.select(currentGeneration, selectionSize, result);
            return result;
        });
        Future<List> crossOverFuture = this.executorService.submit(() -> {
            int crossOverSize = (int)(crossOverRate * (double)generationSize);
            ArrayList<Handle<H>> result = new ArrayList<Handle<H>>(crossOverSize);
            this.crossover(currentGeneration, crossOverSize, result);
            return result;
        });
        try {
            nextGeneration.addAll(selectionFuture.get());
            nextGeneration.addAll(crossOverFuture.get());
        }
        catch (InterruptedException | ExecutionException e) {
            this.handleException(e);
        }
        this.mutate(nextGeneration, (int)(mutationRate * (double)generationSize));
        return nextGeneration;
    }

    @Override
    List<Handle<H>> createRandomHypothesisHandles(int count) {
        ArrayList<Handle<H>> result = new ArrayList<Handle<H>>(count);
        ArrayList<Future<Handle>> futureList = new ArrayList<Future<Handle>>(count);
        for (int i = 0; i < count; ++i) {
            futureList.add(this.executorService.submit(() -> new Handle(this.getAlgorithmDefinition().newRandomHypothesis())));
        }
        for (Future future : futureList) {
            try {
                result.add((Handle)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
            }
        }
        return result;
    }

    @Override
    void select(List<Handle<H>> population, int targetCount, Collection<Handle<H>> targetCollection) {
        ArrayList<Future<Handle>> futureList = new ArrayList<Future<Handle>>(targetCount);
        for (int i = 0; i < targetCount; ++i) {
            futureList.add(this.executorService.submit(() -> this.probabilisticSelect(population)));
        }
        for (Future future : futureList) {
            try {
                targetCollection.add((Handle)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    void crossover(List<Handle<H>> population, int targetCount, Collection<Handle<H>> targetCollection) {
        ArrayList<Future<List>> futureList = new ArrayList<Future<List>>(targetCount);
        for (int i = 0; i < targetCount / 2; ++i) {
            futureList.add(this.executorService.submit(() -> {
                Handle first = this.probabilisticSelect(population);
                Handle second = this.probabilisticSelect(population);
                Collection offsprings = this.getAlgorithmDefinition().crossOverHypothesis(first.getHypothesis(), second.getHypothesis());
                ArrayList offspringHandles = new ArrayList(offsprings.size());
                for (Object offspring : offsprings) {
                    offspringHandles.add(new Handle(offspring));
                }
                return offspringHandles;
            }));
        }
        int childCount = 0;
        for (Future future : futureList) {
            try {
                List children = (List)future.get();
                targetCollection.addAll(children);
                if ((childCount += children.size()) < targetCount) continue;
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    void mutate(List<Handle<H>> selectedSet, int mutationCount) {
        ArrayList futureList = new ArrayList(mutationCount);
        for (int i = 0; i < mutationCount; ++i) {
            futureList.add(this.executorService.submit(() -> {
                int index = this.getRandom().nextInt(selectedSet.size());
                Handle current = (Handle)selectedSet.get(index);
                Object mutated = this.getAlgorithmDefinition().mutateHypothesis(current.getHypothesis());
                selectedSet.set(index, new Handle(mutated));
            }));
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
            }
        }
    }

    @Override
    void updateFitness(List<Handle<H>> population) {
        double sumFitness = 0.0;
        ArrayList<Future<Handle>> futureList = new ArrayList<Future<Handle>>(population.size());
        for (Handle<H> handle : population) {
            if (handle.isHasFitness()) {
                sumFitness += handle.getFitness();
                continue;
            }
            futureList.add(this.executorService.submit(() -> {
                handle.setFitness(this.getAlgorithmDefinition().calculateFitness(handle.getHypothesis()));
                return handle;
            }));
        }
        for (Future future : futureList) {
            try {
                sumFitness += ((Handle)future.get()).getFitness();
            }
            catch (InterruptedException | ExecutionException e) {
                this.handleException(e);
            }
        }
        for (Handle<Object> handle : population) {
            double probability = handle.getFitness() / sumFitness;
            handle.setProbability(probability);
        }
    }
}

