/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.Handle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;

abstract class ComputeEngine<H> {
    private final Random random;
    private final AlgorithmDefinition<H> algorithmDefinition;

    ComputeEngine(Random inRandom, AlgorithmDefinition<H> inAlgorithmDefinition) {
        this.random = inRandom;
        this.algorithmDefinition = inAlgorithmDefinition;
    }

    abstract List<Handle<H>> createRandomHypothesisHandles(int var1);

    abstract List<Handle<H>> calculateNextGeneration(List<Handle<H>> var1, int var2, double var3, double var5);

    abstract void select(List<Handle<H>> var1, int var2, Collection<Handle<H>> var3);

    abstract void crossover(List<Handle<H>> var1, int var2, Collection<Handle<H>> var3);

    abstract void mutate(List<Handle<H>> var1, int var2);

    Handle<H> probabilisticSelect(List<Handle<H>> population) {
        return this.innerProbabilisticSelectSimplifiedStochastic(population);
    }

    private Handle<H> innerProbabilisticSelectRealStochastic(List<Handle<H>> population) {
        Handle<H> result = population.get(0);
        for (int i = 0; i < population.size(); ++i) {
            int index;
            double randomPoint = this.getRandom().nextDouble();
            if (!(randomPoint < (result = population.get(index = this.getRandom().nextInt(population.size()))).getProbability())) continue;
            return result;
        }
        return result;
    }

    private Handle<H> innerProbabilisticSelectSimplifiedStochastic(List<Handle<H>> population) {
        Handle<H> result = population.get(0);
        double randomPoint = this.getRandom().nextDouble();
        double soFar = 0.0;
        for (int i = 0; i < population.size() && soFar < randomPoint; soFar += result.getProbability(), ++i) {
            result = population.get(i);
        }
        return result;
    }

    Optional<Handle<H>> max(List<Handle<H>> in) {
        Handle<H> result = null;
        double resultFitness = 0.0;
        for (int i = 0; i < in.size(); ++i) {
            Handle<H> current = in.get(i);
            if (null != result) {
                double currentFitness = current.getFitness();
                if (!(currentFitness > resultFitness)) continue;
                result = current;
                resultFitness = currentFitness;
                continue;
            }
            result = current;
            resultFitness = current.getFitness();
        }
        return Optional.ofNullable(result);
    }

    abstract void updateFitness(List<Handle<H>> var1);

    Random getRandom() {
        return this.random;
    }

    AlgorithmDefinition<H> getAlgorithmDefinition() {
        return this.algorithmDefinition;
    }
}

