/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic.intarrayguessing;

import de.sfuhrm.genetic.AlgorithmDefinition;
import de.sfuhrm.genetic.intarrayguessing.GuessingExample;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import lombok.Generated;

public final class IntGuessingDefinition
implements AlgorithmDefinition<int[]> {
    private Random random;
    private final int genomeLength;
    private final boolean verbose;
    private static long generation;

    IntGuessingDefinition(int inLength, boolean inVerbose) {
        this.genomeLength = inLength;
        this.verbose = inVerbose;
    }

    public void initialize(Random r) {
        this.random = r;
    }

    public int[] newRandomHypothesis() {
        int[] result = new int[this.genomeLength];
        IntStream.range(0, result.length).forEach(i -> {
            result[i] = this.random.nextInt(result.length);
        });
        return result;
    }

    public int[] mutateHypothesis(int[] instance) {
        int point = this.random.nextInt(instance.length);
        int[] copy = Arrays.copyOf(instance, instance.length);
        copy[point] = this.random.nextInt(instance.length);
        return copy;
    }

    public Collection<int[]> crossOverHypothesis(int[] first, int[] second) {
        int point = this.random.nextInt(first.length);
        int[] offspringOne = new int[first.length];
        int[] offspringTwo = new int[first.length];
        for (int i = 0; i < first.length; ++i) {
            offspringOne[i] = i < point ? first[i] : second[i];
            offspringTwo[i] = i >= point ? second[i] : first[i];
        }
        return Arrays.asList(offspringOne, offspringTwo);
    }

    public double calculateFitness(int[] hypothesis) {
        double fitness = 0.0;
        for (int i = 0; i < hypothesis.length; ++i) {
            int genomeValue = hypothesis[i];
            if (genomeValue == i) {
                fitness += 1.0;
                continue;
            }
            fitness -= (double)Math.abs(genomeValue - i);
        }
        return Math.exp(fitness);
    }

    public boolean loop(int[] hypothesis) {
        ++generation;
        if (this.verbose) {
            GuessingExample.print(hypothesis);
        }
        for (int i = 0; i < hypothesis.length; ++i) {
            if (hypothesis[i] == i) continue;
            return true;
        }
        return false;
    }

    @Generated
    public static long getGeneration() {
        return generation;
    }
}

