/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * This license does not apply to any contained documentation in the source!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.List;
import java.util.Map;
import java.io.IOException;
import de.serviceflow.codegenj.ObjectManager.DBusInterface;

/**
 * interface for org.bluez.GattCharacteristic1
 */  
public interface GattCharacteristic1 extends DBusInterface {
 

    public List<org.bluez.GattDescriptor1> getDescriptors();

    


    /**
     * Reads property UUID.
     *
     * 128-bit characteristic UUID. 
     *
     * @return the property value.
     */
    public String getUUID();



// property signature unsupported: Service



    /**
     * Reads property Value.
     *
     * The cached value of the characteristic. This property gets updated 
			only after a successful read request and when a notification or indication 
			is received, upon which a PropertiesChanged signal will be emitted. 
     *
     * @return the property value.
     */
    public byte[] getValue();




    /**
     * Reads property Notifying.
     *
     * True, if notifications or indications on this characteristic are currently 
			enabled. 
     *
     * @return the property value.
     */
    public boolean getNotifying();




    /**
     * Reads property Flags.
     *
     * Defines how the characteristic value can be used. See Core spec "Table 
			3.5: Characteristic Properties bit field", and "Table 3.8: Characteristic 
			Extended Properties bit field". Allowed values: "broadcast" "read" "write-without-response" 
			"write" "notify" "indicate" "authenticated-signed-writes" "reliable-write" 
			"writable-auxiliaries" "encrypt-read" "encrypt-write" "encrypt-authenticated-read" 
			"encrypt-authenticated-write" "secure-read" (Server only) "secure-write" 
			(Server only) 
     *
     * @return the property value.
     */
    public String[] getFlags();








    /**
     * ReadValue:
     *
     *  Issues a request to read the value of the characteristic and returns 
			the value if the operation was successful. Possible options: "offset": uint16 
			offset "device": Object Device (Server only) Possible Errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.NotPermitted org.bluez.Error.NotAuthorized 
			org.bluez.Error.NotSupported 
     */
    public byte[] readValue() throws IOException;

    /**
     * WriteValue:
     *
     *  Issues a request to write the value of the characteristic. Possible 
			options: "offset": Start offset "device": Device path (Server only) Possible 
			Errors: org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.NotPermitted 
			org.bluez.Error.InvalidValueLength org.bluez.Error.NotAuthorized org.bluez.Error.NotSupported 
     */
    public void writeValue(byte [] value) throws IOException;

    /**
     * StartNotify:
     *
     *  Starts a notification session from this characteristic if it supports 
			value notifications or indications. Possible Errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.NotSupported 
     */
    public void startNotify() throws IOException;

    /**
     * StopNotify:
     *
     *  This method will cancel any previous StartNotify transaction. Note 
			that notifications from a characteristic are shared between sessions thus 
			calling StopNotify will release a single session. 
     */
    public void stopNotify() throws IOException;

}
