/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * This license does not apply to any contained documentation in the source!
 *
 This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import de.serviceflow.codegenj.ObjectManager;
import de.serviceflow.codegenj.ObjectManager.DBusInterfaceProxy;
import java.io.IOException;

/**
 * D-Bus JNI Interface class for org.bluez.Device1
 */  
public abstract class Device1Skeleton extends DBusInterfaceProxy implements Device1 {
     static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
     }
 
     // private Object _proxy = null;

  	 public Device1Skeleton(String path) {
    	_init(path);
     }    
    
     protected native Object _init(String path);
     
     protected native void _destroy();


    /**
     * Connect:
     *
     *  This is a generic method to connect any profiles the remote device 
			supports that can be connected to and have been flagged as auto-connectable 
			on our side. If only subset of profiles is already connected it will try 
			to connect currently disconnected ones. If at least one profile was connected 
			successfully this method will indicate success. Possible errors: org.bluez.Error.NotReady 
			org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.AlreadyConnected 
     */
    public abstract void connect();

    /**
     * Disconnect:
     *
     *  This method gracefully disconnects all connected profiles and then 
			terminates low-level ACL connection. ACL connection will be terminated even 
			if some profiles were not disconnected properly e.g. due to misbehaving device. 
			This method can be also used to cancel a preceding Connect call before a 
			reply to it has been received. Possible errors: org.bluez.Error.NotConnected 
     */
    public abstract void disconnect();

    /**
     * ConnectProfile:
     *
     *  This method connects a specific profile of this device. The UUID provided 
			is the remote service UUID for the profile. Possible errors: org.bluez.Error.Failed 
			org.bluez.Error.InProgress org.bluez.Error.InvalidArguments org.bluez.Error.NotAvailable 
			org.bluez.Error.NotReady 
     */
    public abstract void connectProfile(String UUID);

    /**
     * DisconnectProfile:
     *
     *  This method disconnects a specific profile of this device. The profile 
			needs to be registered client profile. There is no connection tracking for 
			a profile, so as long as the profile is registered this will always succeed. 
			Possible errors: org.bluez.Error.Failed org.bluez.Error.InProgress org.bluez.Error.InvalidArguments 
			org.bluez.Error.NotSupported 
     */
    public abstract void disconnectProfile(String UUID);

    /**
     * Pair:
     *
     *  This method will connect to the remote device, initiate pairing and 
			then retrieve all SDP records (or GATT primary services). If the application 
			has registered its own agent, then that specific agent will be used. Otherwise 
			it will use the default agent. Only for applications like a pairing wizard 
			it would make sense to have its own agent. In almost all other cases the 
			default agent will handle this just fine. In case there is no application 
			agent and also no default agent present, this method will fail. Possible 
			errors: org.bluez.Error.InvalidArguments org.bluez.Error.Failed org.bluez.Error.AlreadyExists 
			org.bluez.Error.AuthenticationCanceled org.bluez.Error.AuthenticationFailed 
			org.bluez.Error.AuthenticationRejected org.bluez.Error.AuthenticationTimeout 
			org.bluez.Error.ConnectionAttemptFailed 
     */
    public abstract void pair();

    /**
     * CancelPairing:
     *
     *  This method can be used to cancel a pairing operation initiated by 
			the Pair method. Possible errors: org.bluez.Error.DoesNotExist org.bluez.Error.Failed 
     */
    public abstract void cancelPairing();

}
