/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * This license does not apply to any contained documentation in the source!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.List;
import java.util.Map;
import java.io.IOException;
import de.serviceflow.codegenj.ObjectManager.DBusInterface;

/**
 * interface for org.bluez.AgentManager1
 */  
public interface AgentManager1 extends DBusInterface {
 

    



    /**
     * RegisterAgent:
     *
     *  This registers an agent handler. The object path defines the path 
			of the agent that will be called when user input is needed. Every application 
			can register its own agent and for all actions triggered by that application 
			its agent is used. It is not required by an application to register an agent. 
			If an application does chooses to not register an agent, the default agent 
			is used. This is on most cases a good idea. Only application like a pairing 
			wizard should register their own agent. An application can only register 
			one agent. Multiple agents per application is not supported. The capability 
			parameter can have the values "DisplayOnly", "DisplayYesNo", "KeyboardOnly", 
			"NoInputNoOutput" and "KeyboardDisplay" which reflects the input and output 
			capabilities of the agent. If an empty string is used it will fallback to 
			"KeyboardDisplay".
			
			if (g_str_equal(capability, ""))
927		return IO_CAPABILITY_KEYBOARDDISPLAY;
928	if (g_str_equal(capability, "DisplayOnly"))
929		return IO_CAPABILITY_DISPLAYONLY;
930	if (g_str_equal(capability, "DisplayYesNo"))
931		return IO_CAPABILITY_DISPLAYYESNO;
932	if (g_str_equal(capability, "KeyboardOnly"))
933		return IO_CAPABILITY_KEYBOARDONLY;
934	if (g_str_equal(capability, "NoInputNoOutput"))
935		return IO_CAPABILITY_NOINPUTNOOUTPUT;
936	if (g_str_equal(capability, "KeyboardDisplay"))
937		return IO_CAPABILITY_KEYBOARDDISPLAY;
938	return IO_CAPABILITY_INVALID;
			
			 Possible errors: org.bluez.Error.InvalidArguments org.bluez.Error.AlreadyExists 
     */
    public void registerAgent(Object agent, String capability) throws IOException;

    /**
     * UnregisterAgent:
     *
     *  This unregisters the agent that has been previously registered. The 
			object path parameter must match the same value that has been used on registration. 
			Possible errors: org.bluez.Error.DoesNotExist 
     */
    public void unregisterAgent(Object agent) throws IOException;

    /**
     * RequestDefaultAgent:
     *
     *  This requests is to make the application agent the default agent. 
			The application is required to register an agent. Special permission might 
			be required to become the default agent. Possible errors: org.bluez.Error.DoesNotExist 
     */
    public void requestDefaultAgent(Object agent) throws IOException;

}
