/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * This license does not apply to any contained documentation in the source!
 *
 This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package org.bluez;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import de.serviceflow.codegenj.ObjectManager;
import de.serviceflow.codegenj.ObjectManager.DBusInterfaceProxy;
import java.io.IOException;

/**
 * D-Bus JNI Interface class for org.bluez.Agent1
 */  
public abstract class Agent1CB extends DBusInterfaceProxy implements Agent1 {
     static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
     }
 
     // private Object _proxy = null;

  	 public Agent1CB(String path) {
    	_init(path);
     }    
    
     protected native Object _init(String path);
     
     protected native void _destroy();


    /**
     * Release:
     *
     *  This method gets called when the service daemon unregisters the agent. 
			An agent can use it to do cleanup tasks. There is no need to unregister the 
			agent, because when this method gets called it has already been unregistered. 
     */
    public abstract void release();

    /**
     * RequestPinCode:
     *
     *  This method gets called when the service daemon needs to get the passkey 
			for an authentication. The return value should be a string of 1-16 characters 
			length. The string can be alphanumeric. Possible errors: org.bluez.Error.Rejected 
			org.bluez.Error.Canceled 
     */
    public abstract String requestPinCode(Object device);

    /**
     * DisplayPinCode:
     *
     *  This method gets called when the service daemon needs to display a 
			pincode for an authentication. An empty reply should be returned. When the 
			pincode needs no longer to be displayed, the Cancel method of the agent will 
			be called. This is used during the pairing process of keyboards that don't 
			support Bluetooth 2.1 Secure Simple Pairing, in contrast to DisplayPasskey 
			which is used for those that do. This method will only ever be called once 
			since older keyboards do not support typing notification. Note that the PIN 
			will always be a 6-digit number, zero-padded to 6 digits. This is for harmony 
			with the later specification. Possible errors: org.bluez.Error.Rejected org.bluez.Error.Canceled 
     */
    public abstract void displayPinCode(Object device, String pincode);

    /**
     * RequestPasskey:
     *
     *  This method gets called when the service daemon needs to get the passkey 
			for an authentication. The return value should be a numeric value between 
			0-999999. Possible errors: org.bluez.Error.Rejected org.bluez.Error.Canceled 
     */
    public abstract int requestPasskey(Object device);

    /**
     * DisplayPasskey:
     *
     *  This method gets called when the service daemon needs to display a 
			passkey for an authentication. The entered parameter indicates the number 
			of already typed keys on the remote side. An empty reply should be returned. 
			When the passkey needs no longer to be displayed, the Cancel method of the 
			agent will be called. During the pairing process this method might be called 
			multiple times to update the entered value. Note that the passkey will always 
			be a 6-digit number, so the display should be zero-padded at the start if 
			the value contains less than 6 digits. 
     */
    public abstract void displayPasskey(Object device, int passkey, short entered);

    /**
     * RequestConfirmation:
     *
     *  This method gets called when the service daemon needs to confirm a 
			passkey for an authentication. To confirm the value it should return an empty 
			reply or an error in case the passkey is invalid. Note that the passkey will 
			always be a 6-digit number, so the display should be zero-padded at the start 
			if the value contains less than 6 digits. Possible errors: org.bluez.Error.Rejected 
			org.bluez.Error.Canceled 
     */
    public abstract void requestConfirmation(Object device, int passkey);

    /**
     * RequestAuthorization:
     *
     *  This method gets called to request the user to authorize an incoming 
			pairing attempt which would in other circumstances trigger the just-works 
			model. Possible errors: org.bluez.Error.Rejected org.bluez.Error.Canceled 
     */
    public abstract void requestAuthorization(Object device);

    /**
     * AuthorizeService:
     *
     *  This method gets called when the service daemon needs to authorize 
			a connection/service request. Possible errors: org.bluez.Error.Rejected org.bluez.Error.Canceled 
     */
    public abstract void authorizeService(Object device, String uuid);

    /**
     * Cancel:
     *
     *  This method gets called to indicate that the agent request failed 
			before a reply was returned. 
     */
    public abstract void cancel();

}
