/* Source generated by codegenj (https://github.com/olir/codegenj) - DO NOT EDIT!
 *
 * This generated output is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 */
package de.serviceflow.codegenj;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * D-Bus JNI Interface class for ObjectManager
 */  
public class ObjectManager {
    static {
        System.loadLibrary("bluezdbus"); // Load native library libbluezdbus.so at runtime
    }
 
    private static ObjectManager instance = null;

	private final static Logger LOGGER = Logger.getLogger(ObjectManager.class.getName()); 

    public static ObjectManager getInstance() {
    	synchronized(ObjectManager.class) {
    		if (instance==null) {
    			new ObjectManager();
    		}
    	}
    	return instance;
    }

	public final static Logger getLogger() {
		return LOGGER;
	}

	/**
	 * for JNI: <=500 (FINE) triggers logging
	 */
	private final static int getLogLevelIntValue() {
		Logger l = LOGGER;
		do {
			Level level = l.getLevel();
			if (level!=null) {
				return level.intValue();
			}
			l = l.getParent();
		} while(l!=null);
		return Integer.MAX_VALUE;
	}

    private Object _client;
    private final String objectpath;

    private ObjectManager() {
    	this("/");
    	instance = this;
    	initCollectorAPI();
    	_run();
	}
	    
    protected ObjectManager(String objectpath) {
    	if (objectpath.length()<=1 && objectpath.charAt(0)=='/') {
    		if (instance!=null)
    			throw new Error("Use getInstance() to obtain System root instance.");
    	}
    	if (objectpath.charAt(objectpath.length()-1)!='/') {
    		objectpath = objectpath + "/";
    	}
    	_init(objectpath);
    	this.objectpath = objectpath;
    	
    	if (getLogger().isLoggable(Level.FINER))
			System.out.println("*** ObjectManager : Direct Buffer with NativeReference : "+ _client);
     }
    
     private native void _init(String objectpath);
     
     private native void _run();
     
     public native void _destroy();
 
 	 public String getObjectPath() {
 	 	return objectpath;
 	 }
 	 
     public native Object [] getProxyObjects(String interfacename, boolean initial);

     public native String getObjectPath(Object proxy);

     public native void dump();


	 static private Map<String, org.bluez.AgentManager1> agentmanager1Map = null;

    static public void addAgentManager1Object(String path, Object proxy) {
   			org.bluez.AgentManager1Proxy n = new org.bluez.AgentManager1Proxy(proxy);
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		agentmanager1Map.put(path, n);
    		n.setObjectPath(path);
	}
	
    static public void removeAgentManager1Object(String path, Object proxy) {
   			if (path==null)
	   			path = ObjectManager.getInstance().getObjectPath(proxy);
    		org.bluez.AgentManager1Proxy n = (org.bluez.AgentManager1Proxy)agentmanager1Map.get(path);
    		n._destroy();
    		agentmanager1Map.remove(path);
	}
	
     static public void initializeAgentManager1Mapping() {
    		agentmanager1Map = Collections.synchronizedMap(new HashMap<String, org.bluez.AgentManager1>());
	    	if (true) {
				Object [] newProxies =  ObjectManager.getInstance().getProxyObjects("org.bluez.AgentManager1", true);
		    	for (Object proxy : newProxies) {
		   			addAgentManager1Object(null, proxy);
		    	}
				System.out.println("*** agentmanager1Map initialized, count="+(newProxies.length));
			}
    }

    public List<org.bluez.AgentManager1> getAgentManagers() {
    	if (!true) {
    		agentmanager1Map.clear();
			Object [] newProxies =  ObjectManager.getInstance().getProxyObjects("org.bluez.AgentManager1", true);
	    	for (Object proxy : newProxies) {
	   			addAgentManager1Object(null, proxy);
	    	}
			System.out.println("*** agentmanager1Map initialized, count="+(newProxies.length));
		}

		List<org.bluez.AgentManager1> resultList = new ArrayList<org.bluez.AgentManager1>();
		String prefix = objectpath;
		if (prefix.length()>0 && prefix.charAt(prefix.length()-1)!='/') {
			prefix = prefix + '/';
		}
		for (Map.Entry<String, org.bluez.AgentManager1> entry : agentmanager1Map.entrySet()) {
			String key = entry.getKey();
			if (key.startsWith(prefix)) {
				resultList.add(entry.getValue());
			}
		}
		return resultList;
    }

	 static private Map<String, org.bluez.Adapter1> adapter1Map = null;

    static public void addAdapter1Object(String path, Object proxy) {
   			org.bluez.Adapter1Proxy n = new org.bluez.Adapter1Proxy(proxy);
   			if (path==null)
   				path = ObjectManager.getInstance().getObjectPath(proxy);
    		adapter1Map.put(path, n);
    		n.setObjectPath(path);
	}
	
    static public void removeAdapter1Object(String path, Object proxy) {
   			if (path==null)
	   			path = ObjectManager.getInstance().getObjectPath(proxy);
    		org.bluez.Adapter1Proxy n = (org.bluez.Adapter1Proxy)adapter1Map.get(path);
    		n._destroy();
    		adapter1Map.remove(path);
	}
	
     static public void initializeAdapter1Mapping() {
    		adapter1Map = Collections.synchronizedMap(new HashMap<String, org.bluez.Adapter1>());
	    	if (true) {
				Object [] newProxies =  ObjectManager.getInstance().getProxyObjects("org.bluez.Adapter1", true);
		    	for (Object proxy : newProxies) {
		   			addAdapter1Object(null, proxy);
		    	}
				System.out.println("*** adapter1Map initialized, count="+(newProxies.length));
			}
    }

    public List<org.bluez.Adapter1> getAdapters() {
    	if (!true) {
    		adapter1Map.clear();
			Object [] newProxies =  ObjectManager.getInstance().getProxyObjects("org.bluez.Adapter1", true);
	    	for (Object proxy : newProxies) {
	   			addAdapter1Object(null, proxy);
	    	}
			System.out.println("*** adapter1Map initialized, count="+(newProxies.length));
		}

		List<org.bluez.Adapter1> resultList = new ArrayList<org.bluez.Adapter1>();
		String prefix = objectpath;
		if (prefix.length()>0 && prefix.charAt(prefix.length()-1)!='/') {
			prefix = prefix + '/';
		}
		for (Map.Entry<String, org.bluez.Adapter1> entry : adapter1Map.entrySet()) {
			String key = entry.getKey();
			if (key.startsWith(prefix)) {
				resultList.add(entry.getValue());
			}
		}
		return resultList;
    }


	public void initCollectorAPI() {
			System.out.println("*** initCollectorAPI() start");
    	org.bluez.Adapter1Proxy.initializeDevice1Mapping();
    	org.bluez.Adapter1Proxy.initializeDevice1Mapping();
    	org.bluez.Device1Proxy.initializeGattService1Mapping();
    	org.bluez.Device1Proxy.initializeGattService1Mapping();
    	org.bluez.GattService1Proxy.initializeGattCharacteristic1Mapping();
    	org.bluez.GattService1Proxy.initializeGattCharacteristic1Mapping();
    	org.bluez.GattCharacteristic1Proxy.initializeGattDescriptor1Mapping();
    	org.bluez.GattCharacteristic1Proxy.initializeGattDescriptor1Mapping();
    	de.serviceflow.codegenj.ObjectManager.initializeAgentManager1Mapping();
    	de.serviceflow.codegenj.ObjectManager.initializeAdapter1Mapping();

			System.out.println("*** initCollectorAPI() end");
	}

    public void addObjectToCollection(String objectpath, String interfaceName, Object proxy) {
//			System.out.println("   ~ addObjectToCollection("+interfaceName+")");
    	if ("org.bluez.Device1".equals(interfaceName)) { org.bluez.Adapter1Proxy.addDevice1Object(objectpath,  proxy); }
    	if ("org.bluez.Device1".equals(interfaceName)) { org.bluez.Adapter1Proxy.addDevice1Object(objectpath,  proxy); }
    	if ("org.bluez.GattService1".equals(interfaceName)) { org.bluez.Device1Proxy.addGattService1Object(objectpath,  proxy); }
    	if ("org.bluez.GattService1".equals(interfaceName)) { org.bluez.Device1Proxy.addGattService1Object(objectpath,  proxy); }
    	if ("org.bluez.GattCharacteristic1".equals(interfaceName)) { org.bluez.GattService1Proxy.addGattCharacteristic1Object(objectpath,  proxy); }
    	if ("org.bluez.GattCharacteristic1".equals(interfaceName)) { org.bluez.GattService1Proxy.addGattCharacteristic1Object(objectpath,  proxy); }
    	if ("org.bluez.GattDescriptor1".equals(interfaceName)) { org.bluez.GattCharacteristic1Proxy.addGattDescriptor1Object(objectpath,  proxy); }
    	if ("org.bluez.GattDescriptor1".equals(interfaceName)) { org.bluez.GattCharacteristic1Proxy.addGattDescriptor1Object(objectpath,  proxy); }
    	if ("org.bluez.AgentManager1".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.addAgentManager1Object(objectpath,  proxy); }    	if ("org.bluez.Adapter1".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.addAdapter1Object(objectpath,  proxy); }
	}
	
    public void removeObjectFromCollection(String objectpath, String interfaceName, Object proxy) {
    	if ("org.bluez.Device1".equals(interfaceName)) { org.bluez.Adapter1Proxy.removeDevice1Object(objectpath,  proxy); }
    	if ("org.bluez.Device1".equals(interfaceName)) { org.bluez.Adapter1Proxy.removeDevice1Object(objectpath,  proxy); }
    	if ("org.bluez.GattService1".equals(interfaceName)) { org.bluez.Device1Proxy.removeGattService1Object(objectpath,  proxy); }
    	if ("org.bluez.GattService1".equals(interfaceName)) { org.bluez.Device1Proxy.removeGattService1Object(objectpath,  proxy); }
    	if ("org.bluez.GattCharacteristic1".equals(interfaceName)) { org.bluez.GattService1Proxy.removeGattCharacteristic1Object(objectpath,  proxy); }
    	if ("org.bluez.GattCharacteristic1".equals(interfaceName)) { org.bluez.GattService1Proxy.removeGattCharacteristic1Object(objectpath,  proxy); }
    	if ("org.bluez.GattDescriptor1".equals(interfaceName)) { org.bluez.GattCharacteristic1Proxy.removeGattDescriptor1Object(objectpath,  proxy); }
    	if ("org.bluez.GattDescriptor1".equals(interfaceName)) { org.bluez.GattCharacteristic1Proxy.removeGattDescriptor1Object(objectpath,  proxy); }
    	if ("org.bluez.AgentManager1".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.removeAgentManager1Object(objectpath,  proxy); }    	if ("org.bluez.Adapter1".equals(interfaceName)) { de.serviceflow.codegenj.ObjectManager.removeAdapter1Object(objectpath,  proxy); }
	}

	static private List<ObjectManagerSignalListener> objectManagerSignalListeners = 
		Collections.synchronizedList(new ArrayList<ObjectManagerSignalListener>());
	
	static protected void dispatchObjectManagerSignal(String signalname, String objectpath, String interfaceName, Object proxy) {

		if ("object-added".equals(signalname)) {
			for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
				l.objectAdded( getInstance(), objectpath);
			}
		}
		else
		if ("object-removed".equals(signalname)) {
			for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
				l.objectRemoved( getInstance(), objectpath);
			}
		}
		else
		if ("interface-added".equals(signalname)) {
			getInstance().addObjectToCollection(objectpath, interfaceName, proxy);

			for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
				l.interfaceAdded( getInstance(), objectpath, interfaceName);
			}
		}
		else
		if ("interface-removed".equals(signalname)) {
			for (ObjectManagerSignalListener l : objectManagerSignalListeners) {
				l.interfaceRemoved( getInstance(), objectpath, interfaceName);
			}
			getInstance().removeObjectFromCollection(objectpath, interfaceName, proxy);
		}
	}

	public void addObjectManagerSignalListener(ObjectManagerSignalListener l) {
		objectManagerSignalListeners.add(l);
	}

	public void removeObjectManagerSignalListener(ObjectManagerSignalListener l) {
		objectManagerSignalListeners.remove(l);
	}

	public interface ObjectManagerSignalListener {
		void interfaceAdded(ObjectManager m, String op, String i);
		void interfaceRemoved(ObjectManager m, String op, String i);
		void objectAdded(ObjectManager m, String op);
		void objectRemoved(ObjectManager m, String op);
	}
	
	public static interface DBusInterface {
		public String getObjectPath();		
	}

	public static class DBusInterfaceProxy implements DBusInterface {
        private String objectpath;

		protected DBusInterfaceProxy() {
		}

		public String getObjectPath() {
 	 		return objectpath;
		}
		
		public void setObjectPath(String path) {
 	 		objectpath = path;
		}
	}
}
