/*
 * Decompiled with CFR 0.152.
 */
package org.bluez;

import de.serviceflow.codegenj.ObjectManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bluez.Device1;

public class Adapter1
extends ObjectManager.DBusInterface {
    private Object _proxy;
    private static Map<String, Device1> device1Map;

    public Adapter1(Object proxy) {
        this._proxy = proxy;
        this._init();
    }

    public native void _init();

    public native void _destroy();

    public static void addDevice1Object(String path, Object proxy) {
        Device1 n = new Device1(proxy);
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        device1Map.put(path, n);
        n.setObjectPath(path);
    }

    public static void removeDevice1Object(String path, Object proxy) {
        if (path == null) {
            path = ObjectManager.getInstance().getObjectPath(proxy);
        }
        Device1 n = device1Map.get(path);
        n._destroy();
        device1Map.remove(path);
    }

    public static void initializeDevice1Mapping() {
        Object[] newProxies;
        device1Map = Collections.synchronizedMap(new HashMap());
        for (Object proxy : newProxies = ObjectManager.getInstance().getProxyObjects("org.bluez.Device1", true)) {
            Adapter1.addDevice1Object(null, proxy);
        }
        System.out.println("*** device1Map initialized, count=" + newProxies.length);
    }

    public List<Device1> getDevices() {
        ArrayList<Device1> resultList = new ArrayList<Device1>();
        String prefix = this.getObjectPath();
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
            prefix = prefix + '/';
        }
        for (Map.Entry<String, Device1> entry : device1Map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    public native String getAddress();

    public native String getName();

    public native String getAlias();

    public native void setAlias(String var1);

    public native int getClassProperty();

    public native boolean getPowered();

    public native void setPowered(boolean var1);

    public native boolean getDiscoverable();

    public native void setDiscoverable(boolean var1);

    public native boolean getPairable();

    public native void setPairable(boolean var1);

    public native int getPairableTimeout();

    public native void setPairableTimeout(int var1);

    public native int getDiscoverableTimeout();

    public native void setDiscoverableTimeout(int var1);

    public native boolean getDiscovering();

    public native String[] getUUIDs();

    public native String getModalias();

    public native void startDiscovery() throws IOException;

    public native void stopDiscovery() throws IOException;

    public native void removeDevice(Object var1) throws IOException;

    static {
        System.loadLibrary("bluezdbus");
        device1Map = null;
    }
}

